/* tkhd.h */

#ifndef TKHD_H
#define TKHD_H

#include "qtime_io.h"
#include "atom.h"
#include "matrix.h"

#define QTIME_TYPE_TKHD    QTIME_TYPE('t','k','h','d')

#define TRACK_FLAG_ENABLED 0x0001
#define TRACK_FLAG_MOVIE   0x0002
#define TRACK_FLAG_PREVIEW 0x0004
#define TRACK_FLAG_POSTER  0x0008

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t creation_time;
  uint32_t modification_time;
  int32_t  track_id;                 // 0 is invalid value.
  int32_t  reserved1;
  uint32_t duration;
  uint8_t  reserved2[8];
  int16_t  layer;
  int16_t  alternate_group;
  int16_t  volume;
  int16_t  reserved3;
  matrix_t matrix;
  int32_t  track_width;
  int32_t  track_height;
} TKHD_PROP;

#define TKHD_PROP_SIZE (84)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t creation_time;
  uint32_t modification_time;
  int32_t  track_id;
  int32_t  reserved1;
  uint32_t duration;
  int32_t  reserved2[2];
  int16_t  layer;
  int16_t  alternate_group;
  int16_t  volume;
  int16_t  reserved3;
  matrix_t matrix;
  int32_t  track_width;
  int32_t  track_height;
} tkhd_t;


void    tkhd_init(tkhd_t *tkhd);
void    tkhd_clean(tkhd_t *tkhd);
tkhd_t* tkhd_new(void);
void    tkhd_delete(tkhd_t *tkhd);

int64_t tkhd_calc_size(tkhd_t *tkhd);
tkhd_t* tkhd_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, tkhd_t *tkhd);
tkhd_t* tkhd_create(tkhd_t *tkhd);
int     tkhd_write_atom(qtime_io_t *qtio, tkhd_t *tkhd);
void    tkhd_dump(const char *parent_types, tkhd_t *tkhd);

int     tkhd_set_duration(tkhd_t *tkhd, uint32_t duration);


#endif /* TKHD_H */

