/* test.c */

#include <stdio.h>
#include <stdlib.h>

#include "qtime.h"


int
main(int argc, char *argv[])
{
  char *fname = NULL;
  qtime_t *qt;
  qtime_track_t *qtrk;
  qtime_track_t *video_track;
  qtime_track_t *sound_track;
  int i;
  qtime_t *oqt;
  qtime_track_t *ovtrk;
  qtime_track_t *ostrk;

  if (argc > 1)
    fname = argv[1];

  if (!fname) {
    fprintf(stdout, "usage: %s <mov file>\n", argv[0]);
    exit(0);
  }

  if ((qt = qtime_open_read(fname)) == NULL) {
    fprintf(stderr, "%s open failed.\n", fname);
    exit(1);
  }

  if ((oqt = qtime_open_write("out.mov")) == NULL) {
    fprintf(stderr, "out.mov open failed.\n");
    exit(1);
  }

  qtrk = video_track = sound_track = NULL;
  i = 0;
  do {
    uint32_t media_type;
    qtrk = qtime_get_next_track(qt, qtrk);
    media_type = qtime_track_get_media_type(qtrk);
    if (media_type == QTIME_MEDIA_TYPE_VIDEO)
      video_track = qtrk;
    else if (media_type == QTIME_MEDIA_TYPE_SOUND)
      sound_track = qtrk;
    printf("track[%d]: 0x%p, media_type %.4s.\n", i++, qtrk,(char*)&media_type);
  } while (qtrk != NULL);

  if (video_track) {
    uint8_t buf[1024*1024*3];
    int size, keyframe;
    uint32_t count, max_count;
    int width, height;
    double fps;
    uint8_t *compressor;
    printf("video_frames %u\n", qtime_track_get_frames(video_track));
    printf("video width: %d\n", qtime_track_get_width(video_track));
    printf("video height: %d\n", qtime_track_get_height(video_track));
    printf("video fps: %f\n", qtime_track_get_fps(video_track));
    printf("video compressor: %s\n", qtime_track_get_compressor(video_track));
    max_count = qtime_track_get_frames(video_track);

    if ((ovtrk = qtime_track_create(oqt)) == NULL) {
      fprintf(stderr, "track create failed.\n");
      exit(1);
    }

#if 0
    if (qtime_track_set_media_type(ovtrk, QTIME_MEDIA_TYPE_VIDEO) != QTIME_OK) {
      fprintf(stderr, "set media type failed.\n");
    }
#endif
    width = qtime_track_get_width(video_track);
    height = qtime_track_get_height(video_track);
    fps = qtime_track_get_fps(video_track);
    compressor = qtime_track_get_compressor(video_track);

    qtime_track_set_video(ovtrk, width, height, fps, compressor);

#if 0
    if (qtime_track_set_width(ovtrk, width) != QTIME_OK) {
      fprintf(stderr, "set width failed.\n");
    }

    if (qtime_track_set_height(ovtrk, height) != QTIME_OK) {
      fprintf(stderr, "set height failed.\n");
    }

    if (qtime_track_set_compressor(ovtrk, qtime_track_get_compressor(video_track)) != QTIME_OK) {
      fprintf(stderr, "set height failed.\n");
    }

    if (qtime_track_set_fps(ovtrk, fps) != QTIME_OK) {
      fprintf(stderr, "set fps failed.\n");
    }
#endif

    for (count = 0; count < max_count; count++) {
      size = qtime_track_read_frame(video_track, buf, &keyframe);
//      printf("%u: size = %d, key %s\n", count, size, (keyframe)?"yes":"no");
      if (qtime_track_write_frame(ovtrk, buf, size, keyframe) < 0) {
        fprintf(stderr, "write frame failed.\n");
      }
    }

    qtime_dump(oqt);
  }

  if (sound_track) {
    uint8_t buf[1024*1024*3];
    int size;
    uint32_t count, max_count;
    int channels, rate, bits;
    uint8_t *compressor;
    uint8_t version;
    int16_t compression_id;
    uint32_t samples_per_packet, bytes_per_packet;
    uint32_t bytes_per_frame, bytes_per_sample;
    int num_samples;

    printf("audio frames: %u\n", qtime_track_get_frames(sound_track));
    printf("audio time_scale: %u\n", qtime_track_get_media_time_scale(sound_track));
    printf("audio duration: %u\n", qtime_track_get_media_duration(sound_track));
    printf("audio channels: %d\n", qtime_track_get_audio_channels(sound_track));
    printf("audio bits: %d\n", qtime_track_get_audio_bits(sound_track));
    printf("audio rate: %d\n", qtime_track_get_audio_rate(sound_track));
    printf("audio compressor: %s\n", qtime_track_get_compressor(sound_track));

    channels = qtime_track_get_audio_channels(sound_track);
    bits = qtime_track_get_audio_bits(sound_track);
    rate = qtime_track_get_audio_rate(sound_track);
    compressor = qtime_track_get_compressor(sound_track);

    if ((ostrk = qtime_track_create(oqt)) == NULL) {
      fprintf(stderr, "track create failed.\n");
      exit(1);
    }
    qtime_track_set_audio(ostrk, channels, rate, bits, compressor);
    qtime_track_get_audio_ext(sound_track, &version, &compression_id, &samples_per_packet, &bytes_per_packet, &bytes_per_frame, &bytes_per_sample);
    qtime_track_set_audio_ext(ostrk, version, compression_id, samples_per_packet, bytes_per_packet, bytes_per_frame, bytes_per_sample);

    max_count = qtime_track_get_audio_frames(sound_track);

    for (count = 0; count < max_count; count++) {
      size = qtime_track_read_audio_frame(sound_track, buf, &num_samples);
//      printf("%u: size = %d, key %s\n", count, size, (keyframe)?"yes":"no");
      if (qtime_track_write_audio_frame(ostrk, buf, size, num_samples) < 0) {
        fprintf(stderr, "write audio frame failed.\n");
      }
    }
  }

  qtime_close(qt);
  qtime_write_close(oqt);

  exit(0);
}

