/* stsz.h */

#ifndef STSZ_H
#define STSZ_H

#include "qtime_io.h"
#include "qtime_sample_info.h"
#include "atom.h"

#define QTIME_TYPE_STSZ    QTIME_TYPE('s','t','s','z')

#if 0
typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  sample_size;
  int32_t  number_of_entries;
} STSZ_PROP;
#endif

#define STSZ_PROP_SIZE (12)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  sample_size;
  int32_t  number_of_entries;
  int32_t  table_max;
  int32_t  *table;

  uint32_t sample_size_count;
  int64_t  total_size;
} stsz_t;


void    stsz_init(stsz_t *stsz);
void    stsz_clean(stsz_t *stsz);
stsz_t* stsz_new(void);
void    stsz_delete(stsz_t *stsz);


stsz_t* stsz_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, stsz_t *stsz);
stsz_t* stsz_create(stsz_t *stsz);
int     stsz_write_atom(qtime_io_t *qtio, stsz_t *stsz);
int64_t stsz_calc_size(stsz_t *stsz);
void    stsz_dump(const char *parent_types, stsz_t *stsz);
int     stsz_valid(stsz_t *stsz);

uint32_t stsz_get_sample_size(stsz_t *stsz);
int64_t stsz_get_total_size(stsz_t *stsz);
void    stsz_set_total_size(stsz_t *stsz, int64_t total_size);

int32_t stsz_add_size(stsz_t *stsz, int32_t size);
int32_t stsz_add_sizes(stsz_t *stsz, int32_t size, uint32_t count);
//int32_t  stsz_set_size(stsz_t *stsz, int32_t number, uint32_t size);
int32_t stsz_get_size(stsz_t *stsz, uint32_t count);
int64_t stsz_get_sizes(stsz_t *stsz, uint32_t start_count, uint32_t samples);

int     stsz_get_sample_info(stsz_t *stsz, qtime_sample_info_t *spinfo);
int     stsz_add_sample_info(stsz_t *stsz, qtime_sample_info_t *spinfo);


#endif /* STSZ_H */

