/* stss.h */

#ifndef STSS_H
#define STSS_H

#include "qtime_io.h"
#include "qtime_sample_info.h"
#include "atom.h"

#define QTIME_TYPE_STSS    QTIME_TYPE('s','t','s','s')

#if 0
typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
} STSS_PROP;
#endif

#define STSS_PROP_SIZE (8)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
  int32_t  table_max;
  int32_t  *table;

  int32_t  idx;
  uint32_t all_key;
} stss_t;


void    stss_init(stss_t *stss);
void    stss_clean(stss_t *stss);
stss_t* stss_new(void);
void    stss_delete(stss_t *stss);


stss_t* stss_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, stss_t *stss);
stss_t* stss_create(stss_t *stss);
int     stss_write_atom(qtime_io_t *qtio, stss_t *stss);
int64_t stss_calc_size(stss_t *stss);
void    stss_dump(const char *parent_types, stss_t *stss);
int     stss_valid(stss_t *stss);


int32_t  stss_add_keyframe(stss_t *stss, uint32_t keyframe);
//int32_t  stss_set_keyframe(stss_t *stss, int32_t number, uint32_t keyframe);
//uint32_t stss_get_keyframe(stss_t *stss, int32_t index);
int32_t  stss_is_keyframe(stss_t *stss, uint32_t count);
uint32_t stss_get_prev_keyframe(stss_t *stss, uint32_t count);
uint32_t stss_get_next_keyframe(stss_t *stss, uint32_t count);

int      stss_get_sample_info(stss_t *stss, qtime_sample_info_t *spinfo);
int      stss_add_sample_info(stss_t *stss, qtime_sample_info_t *spinfo);


#endif /* STSS_H */

