/* stsd.h */

#ifndef STSD_H
#define STSD_H

#include "qtime_io.h"
#include "qtime_sample_info.h"
#include "atom.h"
#include "sample_desc.h"

#define QTIME_TYPE_STSD    QTIME_TYPE('s','t','s','d')


typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
} STSD_PROP;

#define STSD_PROP_SIZE (8)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
  sample_desc_t **table;

  uint32_t media_type;
  int64_t  start_offset;
} stsd_t;


void     stsd_init(stsd_t *stsd);
void     stsd_clean(stsd_t *stsd);
stsd_t*  stsd_new(void);
void     stsd_delete(stsd_t *stsd);

stsd_t*  stsd_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, stsd_t *stsd);
int      stsd_read_atom_post(qtime_io_t *qtio, stsd_t *stsd);
stsd_t*  stsd_create(stsd_t *stsd);
int64_t  stsd_calc_size(stsd_t *stsd);
int      stsd_write_atom(qtime_io_t *qtio, stsd_t *stsd);
void     stsd_dump(const char *parent_types, stsd_t *stsd);


int      stsd_get_number_of_entries(stsd_t *stsd);
sample_desc_t* stsd_get_sample_desc(stsd_t *stsd, int idx);
int      stsd_add_sample_desc(stsd_t *stsd, sample_desc_t *sample_desc);

uint32_t stsd_get_media_type(stsd_t *stsd);
int      stsd_set_media_type(stsd_t *stsd, uint32_t media_type);

int      stsd_get_sample_info(stsd_t *stsd, qtime_sample_info_t *spinfo);
int      stsd_add_sample_info(stsd_t *stsd, qtime_sample_info_t *spinfo);


#endif /* STSD_H */

