/* stsc.h */

#ifndef STSC_H
#define STSC_H

#include "qtime_io.h"
#include "qtime_sample_info.h"
#include "atom.h"

#define QTIME_TYPE_STSC    QTIME_TYPE('s','t','s','c')

typedef struct {
  uint32_t count;
  int32_t  chunk;
  uint32_t chunk_start_count;
  int32_t  samples_per_chunk;
  int32_t  sample_description_id;
  uint32_t samples;
  int32_t  consecutive_data;
} sc_info_t;

typedef struct {
  int32_t  first_chunk;
  int32_t  samples_per_chunk;
  int32_t  sample_description_id;
} sample_to_chunk_t;

#define SAMPLE_TO_CHUNK_SIZE (12)

#if 0
typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
} STSC_PROP;
#endif

#define STSC_PROP_SIZE (8)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
  int32_t  table_max;
  sample_to_chunk_t *table;

  int32_t  first_chunk;
  int32_t  cur_idx;
  uint32_t st_count;
  uint32_t st_chunk;
  uint32_t ed_count;
  uint32_t ed_chunk;
} stsc_t;


void    stsc_init(stsc_t *stsc);
void    stsc_clean(stsc_t *stsc);
stsc_t* stsc_new(void);
void    stsc_delete(stsc_t *stsc);

stsc_t* stsc_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, stsc_t *stsc);
stsc_t* stsc_create(stsc_t *stsc);
int     stsc_write_atom(qtime_io_t *qtio, stsc_t *stsc);
int64_t stsc_calc_size(stsc_t *stsc);
void    stsc_dump(const char *parent_types, stsc_t *stsc);
int     stsc_valid(stsc_t *stsc);


int32_t stsc_get_chunk(stsc_t *stsc, sc_info_t *si);
int32_t stsc_add_chunk(stsc_t *stsc, sc_info_t *si);
int32_t stsc_add_chunk_finish(stsc_t *stsc);

int32_t stsc_move_init(stsc_t *stsc);

int32_t stsc_get_sample_info(stsc_t *stsc, qtime_sample_info_t *spinfo);
int32_t stsc_add_sample_info(stsc_t *stsc, qtime_sample_info_t *spinfo);


#endif /* STSC_H */

