/* stbl.h */

#ifndef STBL_H
#define STBL_H

#include "qtime_io.h"
#include "atom.h"
#include "stsd.h"
#include "stts.h"
#include "stss.h"
#include "stsc.h"
#include "stsz.h"
#include "stco.h"
//#include "stsh.h"


#define QTIME_TYPE_STBL      QTIME_TYPE('s','t','b','l')


typedef struct {
  atom_t   atom;

  uint32_t media_type;

  stsd_t   stsd;
  stts_t   stts;
  stss_t   stss;
  stsc_t   stsc;
  stsz_t   stsz;
  stco_t   stco;
//  stsh_t   stsh;
} stbl_t;


stbl_t* stbl_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, stbl_t *stbl);
stbl_t* stbl_create(stbl_t *stbl);
int     stbl_write_atom(qtime_io_t *qtio, stbl_t *stbl);

void    stbl_init(stbl_t *stbl);
void    stbl_clean(stbl_t *stbl);
stbl_t* stbl_new(void);
void    stbl_delete(stbl_t *stbl);
void    stbl_dump(const char *parent_types, stbl_t *stbl);
int64_t stbl_calc_size(stbl_t *stbl);

int     stbl_set_media_type(stbl_t *stbl, uint32_t media_type);


#endif /* STBL_H */

