/* sound_desc.h */

#ifndef SOUND_DESC_H
#define SOUND_DESC_H

#include <inttypes.h>

#include "qtime_io.h"
#include "atom.h"
#include "sample_desc.h"


#define QTIME_TYPE_SDSC        QTIME_TYPE('S','D','S','C')

#if 0
typedef struct {
  int16_t  version;
  int16_t  revision_level;
  int32_t  vendor;
  int16_t  number_of_channels;
  int16_t  sample_size;
  int16_t  compression_id;
  int16_t  packet_size;
  uint32_t sample_rate;
} SOUND_DESC_PROP;

typedef struct {
  uint32_t samples_per_packet;
  uint32_t bytes_per_packet;
  uint32_t bytes_per_frame;
  uint32_t bytes_per_sample;
} SOUND_DESC_V1_PROP;
#endif

#define SOUND_DESC_PROP_SIZE (20)
#define SOUND_DESC_V1_PROP_SIZE (16)

typedef struct {
  sample_desc_t sample_desc;
  int16_t  version;
  int16_t  revision_level;
  int32_t  vendor;
  int16_t  number_of_channels;
  int16_t  sample_size;
  int16_t  compression_id;
  int16_t  packet_size;
  uint32_t sample_rate;

  uint32_t samples_per_packet;
  uint32_t bytes_per_packet;
  uint32_t bytes_per_frame;
  uint32_t bytes_per_sample;
} sound_desc_t;


sound_desc_t* sound_desc_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, sound_desc_t *sound_desc);
sound_desc_t* sound_desc_create(sound_desc_t *sound_desc);
int           sound_desc_write_atom(qtime_io_t *qtio, sound_desc_t *sound_desc);
void        sound_desc_dump(const char *parent_types, sound_desc_t *sound_desc);


void          sound_desc_init(sound_desc_t *sound_desc);
sound_desc_t* sound_desc_new(void);
void          sound_desc_clean(sound_desc_t *sound_desc);
void          sound_desc_delete(sound_desc_t *sound_desc);
int64_t       sound_desc_calc_size(sound_desc_t *sound_desc);


#endif /* SOUND_DESC_H */

