/* smhd.h */

#ifndef SMHD_H
#define SMHD_H

#include "qtime_io.h"
#include "atom.h"
#include "smhd.h"

#define QTIME_TYPE_SMHD    QTIME_TYPE('s','m','h','d')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int16_t  balance;
  int16_t  reserved;
} SMHD_PROP;

#define SMHD_PROP_SIZE (8)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int16_t  balance;
  int16_t  reserved;
} smhd_t;


void    smhd_init(smhd_t *smhd);
void    smhd_clean(smhd_t *smhd);
smhd_t* smhd_new(void);
void    smhd_delete(smhd_t *smhd);

int64_t smhd_calc_size(smhd_t *smhd);
smhd_t* smhd_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, smhd_t *smhd);
smhd_t* smhd_create(smhd_t *smhd);
int     smhd_write_atom(qtime_io_t *qtio, smhd_t *smhd);
void    smhd_dump(const char *parent_types, smhd_t *smhd);


#endif /* SMHD_H */

