/* qtime_util.h */

#ifndef QTIME_UTIL_H
#define QTIME_UTIL_H

#include <inttypes.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#define MIN_INT32  (-2147483648)
#define MAX_INT32  (2147483647)
#define MAX_UINT32 (4294967295U)


#define qtime_free free


void      qtime_type_to_str(uint32_t type, char str[5]);
void      qtime_type_to_char(uint32_t type, char ch[4]);
void      qtime_char_to_type(char ch[4], uint32_t *type);
int32_t   qtime_float_to_fixed32(float f);
float     qtime_fixed32_to_float(int32_t i);
int16_t   qtime_float_to_fixed16(float f);
float     qtime_fixed16_to_float(int16_t i);

void      qtime_flags_set(uint8_t *flags, uint32_t f);
void      qtime_flags_get(uint8_t *flags, uint32_t *f);
uint32_t  qtime_current_time(void);
char*     qtime_ctime_r(uint32_t time, char *buf);
void     *qtime_malloc(int byte_size);
void     *qtime_realloc(void *ptr, int byte_size);

int       qtime_fps_to_time_scale_duration(double fps, uint32_t *time_scale, uint32_t *duration);
int       qtime_time_scale_duration_to_fps(uint32_t time_scale, uint32_t duration, double *fps);


#endif /* QTIME_UTIL_H */

