/* qtime_sample_desc.h */

#ifndef QTIME_SAMPLE_DESCRIPTION_H
#define QTIME_SAMPLE_DESCRIPTION_H

#include <inttypes.h>

typedef struct {
  uint8_t  data_format[5];
  int16_t  id;
  int16_t  dref_id;
  int16_t  version;
  uint8_t  vendor[5];
  int32_t  temporal_quality;
  int32_t  spatial_quality;
  int16_t  width;
  int16_t  height;
  float    horizontal_resolution;
  float    vertical_resolution;
  int16_t  frame_count;
  uint8_t  compressor_name[32];
  int16_t  depth;
  int16_t  color_table_id;

  int16_t  use_extensions;
  float    gamma;
  uint8_t  field[2];
  void*    mjqt;
  void*    mjht;
} qtime_sample_desc_video_t;

typedef struct {
  uint8_t  data_format[5];
  int16_t  id;
  int16_t  dref_id;
  int16_t  version;
  uint8_t  vendor[5];
  int16_t  number_of_channels;
  int16_t  sample_size;
  int16_t  compression_id;
//  int16_t  packet_size;
  float    sample_rate;

  uint32_t samples_per_packet;
  uint32_t bytes_per_packet;
  uint32_t bytes_per_frame;
  uint32_t bytes_per_sample;
} qtime_sample_desc_sound_t;

typedef struct {
  uint8_t version;
  int16_t compression_id;
  uint32_t samples_per_packet;
  uint32_t bytes_per_packet;
  uint32_t bytes_per_frame;
  uint32_t bytes_per_sample;
} qtime_sample_desc_sound_ext_t;

#endif /* QTIME_SAMPLE_DESCRIPTION_H */

