/* qtime_sample.h */

#ifndef QTIME_SAMPLE_H
#define QTIME_SAMPLE_H

#include "qtime_io.h"
#include "qtime_sample_desc.h"
#include "qtime_sample_info.h"
#include "sound_desc.h"
#include "atom.h"
#include "stbl.h"


#define QTIME_TYPE_QTSP  QTIME_TYPE('Q','T','S','P')

#if 0
typedef struct {
  uint32_t count;
  uint32_t duration;
  int32_t  sample_size;
  uint32_t sample_duration;
  int32_t  sample_description_id;
#define QTIME_SAMPLE_KEYFRAME      (1L<<0)
  uint32_t flag;
  void     *sample_data;
} qtime_sample_data_t;
#endif

typedef struct {
  stbl_t *stbl;
  stsd_t *stsd;
  stts_t *stts;
  stss_t *stss;
  stsc_t *stsc;
  stsz_t *stsz;
  stco_t *stco;

  uint32_t media_type;
} qtime_sample_t;


void qtime_sample_init(qtime_sample_t *qtsp);
void qtime_sample_clean(qtime_sample_t *qtsp);
qtime_sample_t* qtime_sample_new(void);
void qtime_sample_delete(qtime_sample_t *qtsp);
void qtime_sample_dump(const char *parent_types, qtime_sample_t *qtsp);


qtime_sample_t* qtime_sample_create(qtime_sample_t *qtsp, stbl_t *stbl);

int64_t  qtime_sample_get_total_size(qtime_sample_t *qtsp);
uint32_t qtime_sample_get_max_count(qtime_sample_t *qtsp);
uint32_t qtime_sample_get_max_duration(qtime_sample_t *qtsp);

uint32_t qtime_sample_duration_to_count(qtime_sample_t *qtsp,uint32_t duration);
uint32_t qtime_sample_count_to_duration(qtime_sample_t *qtsp,uint32_t count);

int      qtime_sample_is_keyframe(qtime_sample_t *qtsp, uint32_t count);
uint32_t qtime_sample_next_keyframe(qtime_sample_t *qtsp, uint32_t count);
uint32_t qtime_sample_prev_keyframe(qtime_sample_t *qtsp, uint32_t count);

sample_desc_t *qtime_sample_get_sample_desc(qtime_sample_t *qtsp, int id);
int32_t  qtime_sample_add_sample_desc(qtime_sample_t *qtsp, sample_desc_t *sample_desc);

uint32_t qtime_sample_get_media_type(qtime_sample_t *qtsp);
int      qtime_sample_set_media_type(qtime_sample_t *qtsp, uint32_t media_type);

int      qtime_sample_set_constant_duration(qtime_sample_t *qtsp, uint32_t sample_duration);

int      qtime_sample_get_sample_info(qtime_sample_t *qtsp, qtime_sample_info_t *spinfo);
int      qtime_sample_add_sample_info(qtime_sample_t *qtsp, qtime_sample_info_t *spinfo);


#endif /* QTIME_SAMPLE_H */

