/* qtime_media.h */

#ifndef QTIME_MEDIA_H
#define QTIME_MEDIA_H

#include "qtime_io.h"
#include "qtime_sample.h"
#include "qtime_sample_info.h"
#include "atom.h"
#include "mdia.h"


#define QTIME_TYPE_QTMD    QTIME_TYPE('Q','T','M','D')

typedef struct {
  mdia_t *mdia;
  mdhd_t *mdhd;
  hdlr_t *hdlr;
  minf_t *minf;
  hdlr_t *minf_hdlr;

  qtime_sample_t qtsp;

  qtime_sample_info_t spinfo_rd;
  qtime_sample_info_t spinfo_wr;

  uint32_t sample_duration;
  int32_t  sample_description_id;
  sample_desc_t *sample_desc;
  int32_t  data_reference_id;

  qtime_io_t *moio;
  uint32_t media_type;
} qtime_media_t;


void qtime_media_init(qtime_media_t *qtmd);
void qtime_media_clean(qtime_media_t *qtmd);
qtime_media_t* qtime_media_new(void);
void qtime_media_delete(qtime_media_t *qtmd);

qtime_media_t* qtime_media_create(qtime_media_t *qtmd, mdia_t *mdia);

int qtime_media_set_moov_io(qtime_media_t *qtmd, qtime_io_t *mvio);
qtime_sample_t* qtime_media_get_qtime_sample(qtime_media_t *qtmd);


uint32_t qtime_media_get_media_type(qtime_media_t *qtmd);
int      qtime_media_set_media_type(qtime_media_t *qtmd, uint32_t media_type);
int      qtime_media_set_data_reference(qtime_media_t *qtmd, uint8_t *name);

uint32_t qtime_media_get_time_scale(qtime_media_t *qtmd);
int      qtime_media_set_time_scale(qtime_media_t *qtmd, uint32_t time_scale);

uint32_t qtime_media_get_max_count(qtime_media_t *qtmd);
uint32_t qtime_media_get_max_duration(qtime_media_t *qtmd);

uint32_t qtime_media_get_count(qtime_media_t *qtmd);
uint32_t qtime_media_set_count(qtime_media_t *qtmd, uint32_t count);
uint32_t qtime_media_get_duration(qtime_media_t *qtmd);
uint32_t qtime_media_set_duration(qtime_media_t *qtmd, uint32_t duration);

int      qtime_media_get_compressor(qtime_media_t *qtmd, char compressor[5]);

int qtime_media_read_video(qtime_media_t *qtmd, uint8_t *buf, int *keyframe);
int qtime_media_read_audio(qtime_media_t *qtmd, uint8_t *buf, int *num_samples);
int qtime_media_write_video(qtime_media_t *qtmd, uint8_t *buf, int size, int keyframe);
int qtime_media_write_audio(qtime_media_t *qtmd, uint8_t *buf, int size, int num_samples);

int qtime_media_get_video_width(qtime_media_t *qtmd);
int qtime_media_get_video_height(qtime_media_t *qtmd);
double qtime_media_get_video_fps(qtime_media_t *qtmd);
int qtime_media_set_video_fps(qtime_media_t *qtmd, double fps);
int qtime_media_set_video(qtime_media_t *qtmd, int width, int height, uint8_t *compressor);
int qtime_media_video_is_keyframe(qtime_media_t *qtmd, uint32_t count);
uint32_t qtime_media_video_next_keyframe(qtime_media_t *qtmd, uint32_t count);
uint32_t qtime_media_video_prev_keyframe(qtime_media_t *qtmd, uint32_t count);

int qtime_media_get_sound_channels(qtime_media_t *qtmd);
int qtime_media_get_sound_bits(qtime_media_t *qtmd);
int qtime_media_get_sound_rate(qtime_media_t *qtmd);
int qtime_media_set_sound(qtime_media_t *qtmd, int channels, int rate, int bits, uint8_t *compressor);
int qtime_media_set_sound_ext(qtime_media_t *qtmd, int8_t version, int16_t compression_id, uint32_t samples_per_packet, uint32_t bytes_per_packet, uint32_t bytes_per_frame, uint32_t bytes_per_sample);
int qtime_media_get_sound_ext(qtime_media_t *qtmd, int8_t *version, int16_t *compression_id, uint32_t *samples_per_packet, uint32_t *bytes_per_packet, uint32_t *bytes_per_frame, uint32_t *bytes_per_sample);


#endif /* QTIME_MEDIA_H */

