/* qtime_io.h */

#ifndef QTIME_IO_H
#define QTIME_IO_H

#include <inttypes.h>

#define QTIME_IO_MODE_READ      1
#define QTIME_IO_MODE_WRITE     2

typedef struct {
  int32_t  size;
  int64_t  start_offset;
  int64_t  end_offset;
  void     *data;
} qtime_io_data_t;


typedef struct {
  const char *name;
  int fd;
  int mode;
  int flag;
  int end_of_file;
  int64_t end_offset;
} qtime_io_t;



int  qtime_io_open(qtime_io_t *qtio, const char *file_name, int mode);
int  qtime_io_close(qtime_io_t *qtio);

int  qtime_io_read(qtime_io_t *qtio, void *buf, int size);
int  qtime_io_read16(qtime_io_t *qtio, uint16_t *p16);
int  qtime_io_read32(qtime_io_t *qtio, uint32_t *p32);
int  qtime_io_read64(qtime_io_t *qtio, uint64_t *p64);
int  qtime_io_read_type(qtime_io_t *qtio, uint32_t *p32);

int  qtime_io_read_data(qtime_io_t *qtio, qtime_io_data_t *qtio_data);
int  qtime_io_write_data(qtime_io_t *qtio, qtime_io_data_t *qtio_data);

int  qtime_io_write(qtime_io_t *qtio, void *buf, int size);
int  qtime_io_write16(qtime_io_t *qtio, uint16_t *p16);
int  qtime_io_write32(qtime_io_t *qtio, uint32_t *p32);
int  qtime_io_write64(qtime_io_t *qtio, uint64_t *p64);
int  qtime_io_write_type(qtime_io_t *qtio, uint32_t *p32);

int64_t qtime_io_get_offset(qtime_io_t *qtio);
int64_t qtime_io_set_offset(qtime_io_t *qtio, int64_t offset);
int64_t qtime_io_end_offset(qtime_io_t *qtio);


void        qtime_io_init(qtime_io_t *qtio);
void        qtime_io_clean(qtime_io_t *qtio);
qtime_io_t* qtime_io_new(void);
void        qtime_io_delete(qtime_io_t *qtio);



#endif /* QTIME_IO_H */

