/* qtime_error.h */

#ifndef QTIME_ERROR_H
#define QTIME_ERROR_H

#define QTIME_OK                         0

#define QTIME_ERROR_NONE                 0
#define QTIME_ERROR                     -1
#define QTIME_ERROR_MEMORY              -2  // size
#define QTIME_ERROR_OPEN_FAIL           -3  // filename
#define QTIME_ERROR_EMPTY_FILENAME      -4  // filename
#define QTIME_ERROR_LSEEK               -5  //
#define QTIME_ERROR_READ                -6  //
#define QTIME_ERROR_ATOM_READ           -7  // type
#define QTIME_ERROR_ATOM_WRITE          -8  // type
#define QTIME_ERROR_ILLEGAL_ATOM        -9  // type, subtype
#define QTIME_ERROR_ATOM_SIZE           -10 // type, size, size
#define QTIME_ERROR_WRITE               -11 //
#define QTIME_END_OF_FILE               -12 //
#define QTIME_ERROR_TOO_MANY_ATOM       -13 // type, subtype
#define QTIME_ERROR_UNKNOWN_ATOM        -14 // type, subtype, size
#define QTIME_ERROR_IO                  -15 // name
#define QTIME_ERROR_INVALID_MEDIA       -16 //

#ifndef NDEBUG

#define qtime_error_debug_info(code) fprintf(stderr,"QTIME_ERROR:%s:%d:%s:%s\n",__FILE__,__LINE__,__FUNCTION__,qtime_error_code_to_string(code))
//#define qtime_error_debug_info() fprintf(stderr,"QTIME_ERROR:%s:%d:%s\n",__FILE__,__LINE__,__FUNCTION__)

#define qtime_type_check(type,subtype) \
        qtime_error_type_check_func((type),(subtype),__FILE__,__LINE__,__FUNCTION__)

#define qtime_error_type_check(type,subtype) \
  if ((type) != (subtype)) { \
    fprintf(stderr, "QTIME_ERROR_TYPE_CHECK:%s:%d:%s:%s\n",__FILE__,__LINE__,__FUNCTION__,qtime_error_code_to_string(QTIME_ERROR_ILLEGAL_ATOM)); \
    qtime_error_illegal_atom((type),(subtype)); \
    return; \
  }

#define qtime_error_type_check_v(type,subtype,ret) \
  if ((type) != (subtype)) { \
    fprintf(stderr, "QTIME_ERROR_TYPE_CHECK:%s:%d:%s:%s\n",__FILE__,__LINE__,__FUNCTION__,qtime_error_code_to_string(QTIME_ERROR_ILLEGAL_ATOM)); \
    qtime_error_illegal_atom((type),(subtype)); \
    return (ret); \
  }

#define qtime_error_media_check_v(type,cur_media,media,ret) \
  if ((cur_media) != QTIME_MEDIA_TYPE_UNKNOWN && \
      (cur_media) != (media)) { \
    fprintf(stderr, "QTIME_ERROR_MEDIA_CHECK:%s:%d:%s:%s\n",__FILE__,__LINE__,__FUNCTION__,qtime_error_code_to_string(QTIME_ERROR_INVALID_MEDIA)); \
    qtime_error_invalid_media((type),(cur_media),(media)); \
    return (ret); \
  }

#else

#define qtime_error_debug_info(code)
#define qtime_type_check(type,subtype)
#define qtime_error_type_check(type,subtype)
#define qtime_error_type_check_v(type,subtype,ret)
#define qtime_error_media_check_v(type,cur_media,media,ret)

#endif

const char *qtime_error_code_to_string(int error_code);
//void qtime_error_print(int error_code, ...);
int  qtime_error_type_check_func(uint32_t type, uint32_t subtype, const char *file, const int line, const char *func);
void qtime_error_illegal_atom(uint32_t cur_type, uint32_t type);
void qtime_error_atom_read(uint32_t cur_type);
void qtime_error_atom_write(uint32_t cur_type);
void qtime_error_unknown_atom(uint32_t cur_type, uint32_t type, int size);
void qtime_error_too_many_atom(uint32_t cur_type, uint32_t type);
void qtime_error_invalid_media(uint32_t cur_type, uint32_t cur_media_type, uint32_t media_type);
void qtime_error_atom_size(uint32_t cur_type, int32_t cur_size, int32_t size);
void qtime_error_empty_filename(void);
void qtime_error_io(const char *cp);
void qtime_error_memory(int size);
void qtime_error_lseek(void);
void qtime_error_open_fail(const char *name);
void qtime_error_read(void);
void qtime_error_write(void);

//void qtime_print_error(int error_code, const char *mess, ...);


#endif /* QTIME_ERROR_H */

