/* qtime_BE.h */

#ifndef QTIME_BE_H
#define QTIME_BE_H

#include <inttypes.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

typedef union {
  uint16_t u;
  uint8_t  c[2];
} UC16;

typedef union {
  uint32_t u;
  uint8_t  c[4];
} UC32;

typedef union {
  uint64_t u;
  uint8_t  c[8];
} UC64;



#ifndef WORDS_BIGENDIAN

#define QTIME_BE16(a,b)    ( ((UC16*)&(b))->c[0] = ((UC16*)&(a))->c[1], \
                             ((UC16*)&(b))->c[1] = ((UC16*)&(a))->c[0] )

#define QTIME_BE32(a,b)    ( ((UC32*)&(b))->c[0] = ((UC32*)&(a))->c[3], \
                             ((UC32*)&(b))->c[1] = ((UC32*)&(a))->c[2], \
                             ((UC32*)&(b))->c[2] = ((UC32*)&(a))->c[1], \
                             ((UC32*)&(b))->c[3] = ((UC32*)&(a))->c[0] )

#define QTIME_BE64(a,b)    ( ((UC64*)&(b))->c[0] = ((UC64*)&(a))->c[7], \
                             ((UC64*)&(b))->c[1] = ((UC64*)&(a))->c[6], \
                             ((UC64*)&(b))->c[2] = ((UC64*)&(a))->c[5], \
                             ((UC64*)&(b))->c[3] = ((UC64*)&(a))->c[4], \
                             ((UC64*)&(b))->c[4] = ((UC64*)&(a))->c[3], \
                             ((UC64*)&(b))->c[5] = ((UC64*)&(a))->c[2], \
                             ((UC64*)&(b))->c[6] = ((UC64*)&(a))->c[1], \
                             ((UC64*)&(b))->c[7] = ((UC64*)&(a))->c[0] )

#else /* __BIG_ENDIAN */

#define QTIME_BE16(a,b)     ((b)=(a))
#define QTIME_BE32(a,b)     ((b)=(a))
#define QTIME_BE64(a,b)     ((b)=(a))

#endif /* WORDS_BIGENDIAN */


#endif /* QTIME_BE_H */

