/* qtime.h */

#ifndef QTIME_H
#define QTIME_H

#include "qtime_io.h"
#include "qtime_error.h"
#include "qtime_track.h"
#include "moov.h"
#include "mdat.h"

typedef struct {
  qtime_io_t qtio;

  moov_t moov;
  mdat_t mdat;

  int qtrk_num;
  qtime_track_t **qtrk_list;

  // internal valiabels
} qtime_t;

qtime_t *qtime_open_read(const char *file_name);
int      qtime_close(qtime_t *qt);
void     qtime_dump(qtime_t *qt);

int      qtime_get_track_num(qtime_t *qt);
qtime_track_t* qtime_get_track(qtime_t *qt);
qtime_track_t* qtime_get_index_track(qtime_t *qt, int index);
qtime_track_t* qtime_get_next_track(qtime_t *qt, qtime_track_t *qtrk);
qtime_track_t* qtime_get_video_track(qtime_t *qt);
qtime_track_t* qtime_get_next_video_track(qtime_t *qt, qtime_track_t *qtrk);
qtime_track_t* qtime_get_sound_track(qtime_t *qt);
qtime_track_t* qtime_get_next_sound_track(qtime_t *qt, qtime_track_t *qtrk);

qtime_t *qtime_open_write(const char *file_name);
int      qtime_write_close(qtime_t *qt);

qtime_track_t* qtime_create_track(qtime_t *qt);


#endif /* QTIME_H */

