/* qtdump.c */

#include <stdio.h>
#include <stdlib.h>

#include "qtime.h"

int
main(int argc, char *argv[])
{
  const char *fname = NULL;
  qtime_t *qt;

  if (argc < 2) {
    fprintf(stdout, "usage: %s <mov file>\n", argv[0]);
    exit(0);
  }

  fname = argv[1];

  qt = qtime_open_read(fname);
  if (!qt) {
    fprintf(stderr, "%s open failed.\n", fname);
    exit(1);
  }

  qtime_dump(qt);

  qtime_close(qt);

  return 0;
}

