/* mvhd.h */

#ifndef MVHD_H
#define MVHD_H

#include "qtime_io.h"
#include "atom.h"
#include "matrix.h"

#define QTIME_TYPE_MVHD    QTIME_TYPE('m','v','h','d')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t creation_time;
  uint32_t modification_time;
  uint32_t time_scale;
  uint32_t duration;
  int32_t  preferred_rate;
  int16_t  preferred_volume;
  uint8_t  reserved[10];
  matrix_t matrix_structure;
  uint32_t preview_time;
  uint32_t preview_duration;
  uint32_t poster_time;
  uint32_t selection_time;
  uint32_t selection_duration;
  uint32_t current_time;
  int32_t  next_track_id;
} MVHD_PROP;

#define MVHD_PROP_SIZE (100)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t creation_time;
  uint32_t modification_time;
  uint32_t time_scale;
  uint32_t duration;
  int32_t  preferred_rate;       // fixed 32
  int16_t  preferred_volume;     // fixed 16
  uint8_t  reserved[10];
  matrix_t matrix;
  uint32_t preview_time;
  uint32_t preview_duration;
  uint32_t poster_time;
  uint32_t selection_time;
  uint32_t selection_duration;
  uint32_t current_time;
  int32_t  next_track_id;
} mvhd_t;


void    mvhd_init(mvhd_t *mvhd);
void    mvhd_clean(mvhd_t *mvhd);
mvhd_t* mvhd_new(void);
void    mvhd_delete(mvhd_t *mvhd);

int64_t mvhd_calc_size(mvhd_t *mvhd);
mvhd_t* mvhd_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, mvhd_t *mvhd);
mvhd_t* mvhd_create(mvhd_t *mvhd);
int     mvhd_write_atom(qtime_io_t *qtio, mvhd_t *mvhd);
void    mvhd_dump(const char *parent_types, mvhd_t *mvhd);

int     mvhd_set_next_track_id(mvhd_t *mvhd, int next_track_id);
int     mvhd_get_next_track_id(mvhd_t *mvhd);
int     mvhd_set_time_scale(mvhd_t *mvhd, uint32_t time_scale);
int     mvhd_set_duration(mvhd_t *mvhd, uint32_t duration);
int     mvhd_update_modification_time(mvhd_t* mvhd);

#endif /* MVHD_H */

