/* minf.h */

#ifndef MINF_H
#define MINF_H

#include "qtime_io.h"
#include "atom.h"
#include "vmhd.h"
#include "smhd.h"
#include "gmhd.h"
#include "gmin.h"
#include "hdlr.h"
#include "dinf.h"
#include "stbl.h"

#define QTIME_TYPE_MINF    QTIME_TYPE('m','i','n','f')

typedef struct {
  atom_t   atom;

  uint32_t media_type;

  vmhd_t   *vmhd;
  smhd_t   *smhd;
  gmhd_t   *gmhd;
  gmin_t   *gmin;
  hdlr_t   hdlr;
  dinf_t   dinf;
  stbl_t   stbl;
} minf_t;


void    minf_init(minf_t *minf);
void    minf_clean(minf_t *minf);
minf_t* minf_new(void);
void    minf_delete(minf_t *minf);

int64_t minf_calc_size(minf_t *minf);
minf_t* minf_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, minf_t *minf);
minf_t* minf_create(minf_t* minf);
int     minf_write_atom(qtime_io_t *qtio, minf_t *minf);
void    minf_dump(const char *parent_types, minf_t *minf);

uint32_t minf_get_media_type(minf_t *minf);
int      minf_set_media_type(minf_t *minf, uint32_t media_type);


#endif /* MINF_H */

