/* mdia.h */

#ifndef MDIA_H
#define MDIA_H

#include "qtime_io.h"
#include "atom.h"
#include "mdhd.h"
#include "hdlr.h"
#include "minf.h"
#include "udta.h"

#define QTIME_TYPE_MDIA    QTIME_TYPE('m','d','i','a')

typedef struct MDIA_T {
  atom_t   atom;

  uint32_t media_type;

  mdhd_t   mdhd;     // mandatory
  hdlr_t   hdlr;
  minf_t   minf;
  udta_t   *udta;
} mdia_t;


void    mdia_init(mdia_t *mdia);
void    mdia_clean(mdia_t *mdia);
mdia_t* mdia_new(void);
void    mdia_delete(mdia_t *mdia);

int64_t mdia_calc_size(mdia_t *mdia);
mdia_t* mdia_read_atom(qtime_io_t *qtio, atom_head_t *atom, mdia_t *mdia);
mdia_t* mdia_create(mdia_t *mdia);
int     mdia_write_atom(qtime_io_t *qtio, mdia_t *mdia);
void    mdia_dump(const char *parent_types, mdia_t *mdia);


uint32_t mdia_get_media_type(mdia_t *mdia);
int      mdia_set_media_type(mdia_t *mdia, uint32_t media_type);


uint32_t mdia_get_media_time_scale(mdia_t *mdia);
uint32_t mdia_get_media_duration(mdia_t *mdia);
int      mdia_set_media_duration(mdia_t *mdia, uint32_t media_duration);


#endif /* MDIA_H */

