/* mdhd.h */

#ifndef MDHD_H
#define MDHD_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_MDHD    QTIME_TYPE('m','d','h','d')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t creation_time;
  uint32_t modification_time;
  uint32_t time_scale;
  uint32_t duration;
  int16_t  language;
  int16_t  quality;
} MDHD_PROP;

#define MDHD_PROP_SIZE (24)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t creation_time;
  uint32_t modification_time;
  uint32_t time_scale;
  uint32_t duration;
  int16_t  language;
  int16_t  quality;
} mdhd_t;


void     mdhd_init(mdhd_t *mdhd);
void     mdhd_clean(mdhd_t *mdhd);
mdhd_t*  mdhd_new(void);
void     mdhd_delete(mdhd_t *mdhd);

mdhd_t*  mdhd_read_atom(qtime_io_t *qt, atom_head_t *atom_head, mdhd_t *mdhd);
mdhd_t*  mdhd_create(mdhd_t *mdhd);
int      mdhd_write_atom(qtime_io_t *qt, mdhd_t *mdhd);
void     mdhd_dump(const char *parent_types, mdhd_t *mdhd);

int64_t  mdhd_calc_size(mdhd_t *mdhd);

uint32_t mdhd_get_time_scale(mdhd_t *mdhd);
void     mdhd_set_time_scale(mdhd_t *mdhd, uint32_t time_scale);
uint32_t mdhd_get_duration(mdhd_t *mdhd);
void     mdhd_set_duration(mdhd_t *mdhd, uint32_t duration);

#endif /* MDHD_H */

