/* mdat.h */

#ifndef MDAT_H
#define MDAT_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_MDAT    QTIME_TYPE('m','d','a','t')

typedef struct MDAT_T {
  atom_t   atom;
  uint32_t type;
  int64_t  ext_size;

  int64_t  start_offset;
  int64_t  end_offset;
//  int64_t  data_start_offset;
//  int64_t  cur_offset;
} mdat_t;

void    mdat_init(mdat_t *mdat);
void    mdat_clean(mdat_t *mdat);
mdat_t *mdat_create(void);
void    mdat_delete(mdat_t *mdat);

int     mdat_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, mdat_t *mdat);

int     mdat_write_init(qtime_io_t *qtio, mdat_t *mdat);
int     mdat_write_end(qtime_io_t *qtio, mdat_t *mdat);
int     mdat_write_finish(qtime_io_t *qtio, mdat_t *mdat);

int64_t mdat_calc_size(mdat_t *mdat);
int     mdat_set_start_offset(mdat_t *mdat, int64_t start_offset);
int     mdat_set_end_offset(mdat_t *mdat, int64_t end_offset);
int64_t mdat_get_start_offset(mdat_t *mdat);
int64_t mdat_get_end_offset(mdat_t *mdat);

void    mdat_dump(mdat_t *mdat);

#endif /* MDAT_H */

