/* kmat.h */

#ifndef KMAT_H
#define KMAT_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_KMAT    QTIME_TYPE('k','m','a','t')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
} KMAT_PROP;

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];

  int32_t  matte_data_size;
  uint8_t  *matte_data;
} kmat_t;


void    kmat_init(kmat_t *kmat);
void    kmat_clean(kmat_t *kmat);
kmat_t* kmat_new(void);
void    kmat_delete(kmat_t *kmat);


int64_t kmat_calc_size(kmat_t *kmat);
int     kmat_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, kmat_t *kmat);
int     kmat_write_atom(qtime_io_t *qtio, kmat_t *kmat);
void    kmat_dump(const char *parent_types, kmat_t *kmat);


#endif /* KMAT_H */

