/* imap.h */

#ifndef IMAP_H
#define IMAP_H

#include "atom.h"

#define TYPE_IMAP    TYPE('i','m','a','p')
#define TYPE_IN      TYPE(0x00,0x00,'i','n')
#define TYPE_TY      TYPE(0x00,0x00,'t','y')
#define TYPE_OBID    TYPE('o','b','i','d')

typedef struct {
  int32_t  size;
  int32_t  type;
  int32_t  input_type;
} INPUT_TYPE;

typedef struct {
  int32_t  size;
  int32_t  type;
  int32_t  input_type;
} input_type_t;

typedef struct {
  int32_t  size;
  int32_t  type;
  int32_t  object_id;
} OBJECT_ID;

typedef struct {
  int32_t  size;
  int32_t  type;
  int32_t  object_id;
} object_id_t;

typedef struct {
  int32_t  size;
  int32_t  type;
  int32_t  atom_id;
  int16_t  reserved;
  int16_t  child_count;
  int32_t  reserved1;
} IN_ATOM;

typedef struct {
  int32_t  size;
  int32_t  type;
  int32_t  atom_id;
  int16_t  reserved;
  int16_t  child_count;
  int32_t  reserved1;

  int      input_type_num;
  input_type_t *input_type;
  int      object_id_num;
  object_id_t  *object_id;
} in_t;

typedef struct {
  int32_t  size;
  int32_t  type;
} IMAP_ATOM;

typedef struct {
  int32_t  size;
  int32_t  type;

  int      in_num;
  in_t     *in;
} imap_t;

#endif /* IMAP_H */

