/* hdlr.h */

#ifndef HDLR_H
#define HDLR_H

#include "atom.h"

#define QTIME_TYPE_HDLR    QTIME_TYPE('h','d','l','r')

#define QTIME_TYPE_MHLR    QTIME_TYPE('m','h','l','r')
#define QTIME_TYPE_DHLR    QTIME_TYPE('d','h','l','r')
#define QTIME_TYPE_ALIS    QTIME_TYPE('a','l','i','s')

#define QTIME_TYPE_VIDE    QTIME_TYPE('v','i','d','e')
#define QTIME_TYPE_SOUN    QTIME_TYPE('s','o','u','n')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t component_type;
  uint32_t component_subtype;
  uint32_t component_manufacturer;
  uint32_t component_flags;
  uint32_t component_flags_mask;
} HDLR_PROP;

#define HDLR_PROP_SIZE (24)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t component_type;
  uint32_t component_subtype;
  uint32_t component_manufacturer;
  uint32_t component_flags;
  uint32_t component_flags_mask;
  uint8_t  *component_name;
} hdlr_t;


void     hdlr_init(hdlr_t *hdlr);
void     hdlr_clean(hdlr_t *hdlr);
hdlr_t*  hdlr_new(void);
void     hdlr_delete(hdlr_t *hdlr);

hdlr_t*  hdlr_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, hdlr_t *hdlr);
hdlr_t*  hdlr_create(hdlr_t *hdlr);
int      hdlr_write_atom(qtime_io_t *qtio, hdlr_t *hdlr);
void     hdlr_dump(const char *parent_types, hdlr_t *hdlr);

int64_t  hdlr_calc_size(hdlr_t *hdlr);

uint32_t hdlr_get_component_type(hdlr_t *hdlr);
void     hdlr_set_component_type(hdlr_t *hdlr, uint32_t component_type);
uint32_t hdlr_get_component_subtype(hdlr_t *hdlr);
void     hdlr_set_component_subtype(hdlr_t *hdlr, uint32_t component_subtype);
uint8_t* hdlr_get_component_name(hdlr_t *hdlr);
int      hdlr_set_component_name(hdlr_t *hdlr, uint8_t *component_name);

uint32_t hdlr_get_media_type(hdlr_t *hdlr);

int      hdlr_set_media_handler(hdlr_t *hdlr, uint32_t media_type);
int      hdlr_set_data_handler(hdlr_t *hdlr, uint32_t subtype);

#endif /* HDLR_H */

