/* gmin.h */

#ifndef GMIN_H
#define GMIN_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_GMIN    QTIME_TYPE('g','m','i','n')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  uint16_t graphics_mode;
  uint16_t opcolor[3];
  int16_t  balance;
  int16_t  reserved;
} GMIN_PROP;

#define GMIN_PROP_SIZE (12)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  uint16_t graphics_mode;
  uint16_t opcolor[3];
  int16_t  balance;
  int16_t  reserved;
} gmin_t;


void    gmin_init(gmin_t *gmin);
void    gmin_clean(gmin_t *gmin);
gmin_t* gmin_new(void);
void    gmin_delete(gmin_t *gmin);

gmin_t* gmin_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, gmin_t *gmin);
gmin_t* gmin_create(gmin_t *gmin);
int     gmin_write_atom(qtime_io_t *qtio, gmin_t *gmin);
int64_t gmin_calc_size(gmin_t *gmin);
void    gmin_dump(const char *parent_types, gmin_t *gmin);


#endif /* GMIN_H */

