/* elst.h */

#ifndef ELST_H
#define ELST_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_ELST    QTIME_TYPE('e','l','s','t')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
} ELST_PROP;

#define ELST_PROP_SIZE (8)

typedef struct {
  uint32_t  track_duration;
  uint32_t  media_time;
  int32_t   media_rate;
} edit_list_t ;

#define EDIT_LIST_SIZE (12)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;

  edit_list_t *edit_list;
} elst_t;


void    elst_init(elst_t *elst);
void    elst_clean(elst_t *elst);
elst_t* elst_new(void);
void    elst_delete(elst_t *elst);


int64_t elst_calc_size(elst_t *elst);
elst_t* elst_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, elst_t *elst);
elst_t* elst_create(elst_t *elst);
int     elst_write_atom(qtime_io_t *qtio, elst_t *elst);
void    elst_dump(const char *parent_types, elst_t *elst);


int     elst_add_table(elst_t *elst, uint32_t track_duration, uint32_t media_time, float media_rate);
int     elst_get_number_of_entries(elst_t *elst);


#endif /* ELST_H */

