/* edts.h */

#ifndef EDTS_H
#define EDTS_H

#include "qtime_io.h"
#include "atom.h"
#include "elst.h"

#define QTIME_TYPE_EDTS    QTIME_TYPE('e','d','t','s')

typedef struct {
  atom_t   atom;
  elst_t   elst;
} edts_t;


void    edts_init(edts_t *edts);
void    edts_clean(edts_t *edts);
edts_t* edts_new(void);
void    edts_delete(edts_t *edts);


int64_t edts_calc_size(edts_t *edts);
edts_t* edts_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, edts_t *edts);
edts_t* edts_create(edts_t *edts);
int     edts_write_atom(qtime_io_t *qtio, edts_t *edts);
void    edts_dump(const char *parent_types, edts_t *edts);


#endif /* EDTS_H */

