/* dref.h */

#ifndef DREF_H
#define DREF_H

#include "atom.h"

#define QTIME_TYPE_DREF    QTIME_TYPE('d','r','e','f')

#define QTIME_TYPE_ALIS QTIME_TYPE('a','l','i','s')
#define QTIME_TYPE_RSRC QTIME_TYPE('r','s','r','c')
#define QTIME_TYPE_URL  QTIME_TYPE('u','r','l',' ')

typedef struct {
  uint8_t version;
  uint8_t flags[3];
} DATA_REF_PROP;

#define DATA_REF_PROP_SIZE (4)

typedef struct {
  uint32_t size;
  uint32_t type;
  uint8_t  version;
#define DREF_FLAG_SELF_REFERENCE 0x0001
  uint8_t  flags[3];
  int32_t  data_size;
  uint8_t  *data;
} data_ref_t;

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
} DREF_PROP;

#define DREF_PROP_SIZE (8)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
  data_ref_t **data_ref;
} dref_t;


void    dref_init(dref_t *dref);
void    dref_clean(dref_t *dref);
dref_t* dref_new(void);
void    dref_delete(dref_t *dref);

dref_t* dref_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, dref_t *dref);
dref_t* dref_create(dref_t *dref);
int     dref_write_atom(qtime_io_t *qtio, dref_t *dref);
int64_t dref_calc_size(dref_t *dref);
void    dref_dump(const char *parent_types, dref_t *dref);


int     dref_add_data_ref(dref_t *dref, uint32_t type, uint32_t flags, uint8_t *data, int data_size);
int     dref_add_alis(dref_t *dref, uint32_t flags, uint8_t *path);

#endif /* DREF_H */

