/* ctab.h */

#ifndef CTAB_H
#define CTAB_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_CTAB    QTIME_TYPE('c','t','a','b')

typedef struct {
  int32_t  color_table_seed;
  uint16_t color_table_flags;
  int16_t  color_table_size;       // zero-relative
} CTAB_PROP;

#define CTAB_PROP_SIZE 8

typedef struct {
  uint16_t alpha; //must be set to 0.
  uint16_t red;
  uint16_t green;
  uint16_t blue;
} color_array_t;

#define COLOR_ARRAY_SIZE (8)

typedef struct {
  atom_t   atom;
  int32_t  color_table_seed;   // must be set to 0.
  uint16_t color_table_flags;  // must be set to 0x8000.
  int16_t  color_table_size;   // zero-relative value.
  color_array_t *color_array;

  int32_t  color_array_max;
} ctab_t;


void    ctab_init(ctab_t *ctab);
void    ctab_clean(ctab_t *ctab);
ctab_t* ctab_new(void);
void    ctab_delete(ctab_t *ctab);
void    ctab_dump(const char *parent_types, ctab_t *ctab);

ctab_t* ctab_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, ctab_t *ctab);
int     ctab_write_atom(qtime_io_t *qtio, ctab_t *ctab);
ctab_t* ctab_create(ctab_t* ctab);


int     ctab_add_table(ctab_t *ctab,
                  uint16_t alpha, uint16_t red, uint16_t green, uint16_t blue);

int32_t ctab_calc_size(ctab_t *ctab);


#endif /* CTAB_H */

