/* crgn.c */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "qtime_io.h"
#include "qtime_util.h"
#include "qtime_error.h"
#include "atom.h"
#include "crgn.h"

void
crgn_init(crgn_t *crgn)
{
  atom_init(&crgn->atom);
  crgn->atom.size = 0;
  crgn->atom.type = QTIME_TYPE_CRGN;
}

void
crgn_clean(crgn_t *crgn)
{
  crgn_init(crgn);
}

crgn_t*
crgn_create(void)
{
  crgn_t *crgn;
  crgn = (crgn_t*)qtime_malloc(sizeof(crgn_t));
  if (!crgn)
    return NULL;
  crgn_init(crgn);
  return crgn;
}

void
crgn_delete(crgn_t *crgn)
{
  if (!crgn) return;
  qtime_free(crgn);
}

int
crgn_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, crgn_t *crgn)
{
#ifndef NDEBUG
  qtime_io_t *io;
  io = qtio;
  if (atom_head->type != QTIME_TYPE_CRGN) {
    qtime_error_debug_info(QTIME_ERROR_ILLEGAL_ATOM);
    qtime_error_print(QTIME_ERROR_ILLEGAL_ATOM, QTIME_TYPE_CRGN, atom_head->type);
    return QTIME_ERROR_ILLEGAL_ATOM;
  }
#endif /* DEBUG */

  crgn->atom.size = atom_head->size;
  crgn->atom.type = QTIME_TYPE_CRGN;
  crgn->atom.parent = atom_head->parent;

  fprintf(stderr, "crgn_read: crgn_read() is not implement.\n");

  return QTIME_OK;
}

crgn_t*
crgn_create_read_atom(qtime_io_t *qtio, atom_head_t *atom_head)
{
  crgn_t *crgn;
  if ((crgn = crgn_create()) == NULL) {
    return NULL;
  }
  if (crgn_read_atom(qtio, atom_head, crgn) < 0) {
    crgn_delete(crgn);
    return NULL;
  }
  return crgn;
}

int64_t
crgn_calc_size(crgn_t *crgn)
{
  int64_t size = 0;

//  size += 8;
  crgn->atom.size = size;
  return size;
}

int
crgn_write_atom(qtime_io_t *qtio, crgn_t *crgn)
{
  atom_head_t atom_head;

  if (crgn->atom.size <= 8)
    return QTIME_OK;

  atom_head_init(&atom_head);
  atom_head.size = crgn->atom.size;
  atom_head.type = crgn->atom.type;
  if (atom_write_header(qtio, &atom_head) < 0) {
    return QTIME_ERROR_ATOM_WRITE;
  }

  if (atom_write_footer(qtio, &atom_head) < 0) {
    return QTIME_ERROR_ATOM_WRITE;
  }

  return QTIME_OK;
}

void
crgn_dump(const char *parent_types, crgn_t *crgn)
{
  int len = strlen(parent_types);
  uint8_t types[len+6];

  sprintf(types, "%s.%.4s", parent_types, (char*)&crgn->atom.type);

  fprintf(stdout, "%s: size         %lld\n", types, crgn->atom.size);
}

