/* csp.h */

#ifndef _CSP_H
#define _CSP_H

#define CSP_UNKNOWN   0       /* unknown csp */
#define CSP_GREY      1       /* Linear greyscale */
#define CSP_HI240     2       /* High 240 cube (BT848) */

#define CSP_RGB32     3       /* 32bit RGB */ 
#define CSP_RGB24     4       /* 24bit RGB */
#define CSP_RGB565    5       /* 565 16 bit RGB */
#define CSP_RGB555    6       /* 555 15bit RGB */

#define CSP_YUV422    7       /* YUV422 capture */
#define CSP_YUYV      8
#define CSP_YUY2      9

#define CSP_UYVY      10      /* The great thing about standards is ... */
#define CSP_YVYU      11
#define CSP_YUV420    12
#define CSP_YUV411    13      /* YUV411 capture */
#define CSP_RAW       14      /* RAW capture (BT848) */
#define CSP_YUV422P   15      /* YUV 4:2:2 Planar */
#define CSP_YUV411P   16      /* YUV 4:1:1 Planar */
#define CSP_YUV420P   17      /* YUV 4:2:0 Planar */
#define CSP_YUV410P   18      /* YUV 4:1:0 Planar */

#define CSP_YV12      19
#define CSP_I420      20
#define CSP_IYUV      21

#define CSP_COMPRESSED 100
#ifdef HAVE_LIBXVIDCORE
#define CSP_XVID       101
#endif /* HAVE_LIBXVIDCORE */
#ifdef HAVE_RTJPEG
#define CSP_RTJPEG     102
#endif /* HAVE_RTJPEG */

#define CSP_YV12_INTERLACE     200

#define Y_LO_LIMIT 16
#define Y_HI_LIMIT 235
#define C_LO_LIMIT 16
#define C_HI_LIMIT 235

int csp_to_pixel_depth(int csp);
const char *csp_to_str(int csp);

#endif /* _CSP_H */

