/* avitoqt.c */

#include <stdio.h>
#include <stdlib.h>

#include <avilib.h>
#include <qtime.h>

#include "mp3_frame.h"

uint8_t *vbuf = NULL;
uint8_t *abuf = NULL;
int channels, bits, format, rate;
int frame_size = 0;
int abuf_size = 0;
int abuf_pos = 0;
int cur_pos = 0;
int abuf_remain = 0;
int audio_read_bytes = 0;
int bytespspl = 0;
int frame_length = 0;
int frame_samples = 0;

int
audio_write(avi_t *avifile, qtime_track_t *aqtrk, int num_samples)
{
  int samples;
  int bytes;
  int spos;
  int result;
  unsigned short *sp;
  int i, spls, start;
  MP3_FRAME mp3frame;

  samples = num_samples;
  if (samples <= 0)
    return 0;

  result = 0;

  while (result < samples) {
    if (format == 0x1) {
      spos = (samples-result) * bytespspl;
      if (spos >= abuf_size)
	fprintf(stderr, "audio_write: buffer overflow, %d, %d.\n", spos, abuf_size);
      if (abuf_pos < spos) {
        bytes = AVI_read_audio(avifile, &abuf[abuf_pos], spos - abuf_pos);
	if (bytes < 0)
	  bytes = 0;
	abuf_pos += bytes;
      }
      spls = abuf_pos / bytespspl;
      if (spls <= 0)
	return result;
      sp = (unsigned short*)abuf;
      for (i = 0; i < spls; i++) {
	*sp = ((*sp)>>8)|((*sp)<<8);
	sp++;
	if (channels == 2) {
	  *sp = ((*sp)>>8)|((*sp)<<8);
	  sp++;
	}
      }
      qtime_track_write_audio(aqtrk, abuf, abuf_pos, spls);
      spos = spls * bytespspl;
      if (spos < abuf_pos)
	memmove(abuf, &abuf[spos], abuf_pos - spos);
      abuf_pos -= spos;
      result += spls;
    } else if (format == 0x55) {
      if (abuf_pos < abuf_size) {
        bytes = AVI_read_audio(avifile, &abuf[abuf_pos], abuf_size - abuf_pos);
	if (bytes < 0)
	  bytes = 0;
	abuf_pos += bytes;
	audio_read_bytes += bytes;
      }

      if (frame_length <= 0) {
	frame_length = mp3_frame_header(&mp3frame, &abuf[cur_pos], abuf_pos-cur_pos, &start);
	frame_samples = mp3frame.frame_samples;
	if (!frame_size && frame_samples > 0)
	  frame_size = frame_samples;
	cur_pos += start;
	if (frame_length <= 0)
	  continue;
      }
      if (start > 0)
	printf("start %d\n", start);

      if ((abuf_pos - cur_pos) >= frame_length) {
        qtime_track_write_audio(aqtrk, &abuf[cur_pos], frame_length, frame_samples);
	cur_pos += frame_length;
        result += frame_samples;
	frame_length = 0;
	frame_samples = 0;
      } else {
	memmove(abuf, &abuf[cur_pos], abuf_pos - cur_pos);
	abuf_pos -= cur_pos;
	cur_pos = 0;
      }
    }
  }

  return result;
}

int
audio_write_end(avi_t *avifile, qtime_track_t *aqtrk)
{
  int bytes;
  int spos;
  int result;
  unsigned short *sp;
  int i, spls, start;
  MP3_FRAME mp3frame;

  result = 0;

  while (1) {
    if (format == 0x1) {
      if (abuf_pos < abuf_size) {
        bytes = AVI_read_audio(avifile, &abuf[abuf_pos], abuf_size - abuf_pos);
	if (bytes <= 0 && abuf_pos == 0)
	  return result;
	abuf_pos += bytes;
      }
      spls = abuf_pos / bytespspl;
      if (spls <= 0)
	return result;
      sp = (unsigned short*)abuf;
      for (i = 0; i < spls; i++) {
	*sp = ((*sp)>>8)|((*sp)<<8);
	sp++;
	if (channels == 2) {
	  *sp = ((*sp)>>8)|((*sp)<<8);
	  sp++;
	}
      }
      qtime_track_write_audio(aqtrk, abuf, abuf_pos, spls);
      spos = spls * bytespspl;
      if (spos < abuf_pos)
	memmove(abuf, &abuf[spos], abuf_pos - spos);
      abuf_pos -= spos;
      result += spls;
    } else if (format == 0x55) {
      if (abuf_pos < abuf_size) {
        bytes = AVI_read_audio(avifile, &abuf[abuf_pos], abuf_size - abuf_pos);
	if (bytes <= 0 && cur_pos >= abuf_pos)
	  return result;
	abuf_pos += bytes;
	audio_read_bytes += bytes;
      }

      if (frame_length <= 0) {
	frame_length = mp3_frame_header(&mp3frame, &abuf[cur_pos], abuf_pos-cur_pos, &start);
	frame_samples = mp3frame.frame_samples;
	if (!frame_size && frame_samples > 0)
	  frame_size = frame_samples;
	cur_pos += start;
	if (frame_length <= 0)
	  continue;
      }

      if ((abuf_pos - cur_pos) >= frame_length) {
        qtime_track_write_audio(aqtrk, &abuf[cur_pos], frame_length, frame_samples);
	cur_pos += frame_length;
        result += frame_samples;
	frame_length = 0;
	frame_samples = 0;
      } else {
	memmove(abuf, &abuf[cur_pos], abuf_pos - cur_pos);
	abuf_pos -= cur_pos;
	cur_pos = 0;
      }
    }
  }

  return result;
}

int main (int argc, char *argv[])
{
  char *avifile_name;
  char *qtfile_name;
  avi_t *avifile;
  qtime_t *qt;
  qtime_track_t *vqtrk;
  qtime_track_t *aqtrk;
  int frames, width, height;
  double fps;
  char *compressor;
  int i;
  int start_sample, end_sample;

  if (argc <= 1) {
    printf("usage: %s <input avi file> <output mov file>\n", argv[0]);
    exit(0);
  }

  if (argc > 1) {
    avifile_name = argv[1];
  }
  if (argc > 2) {
    qtfile_name = argv[2];
  } else {
    qtfile_name = "out.mov";
  }

  avifile = AVI_open_input_file(avifile_name, 1);
  if (!avifile) {
    AVI_print_error("avi file open failed");
    exit(1);
  }

  frames = AVI_video_frames(avifile);
  width = AVI_video_width(avifile);
  height = AVI_video_height(avifile);
  fps = AVI_frame_rate(avifile);
  compressor = AVI_video_compressor(avifile);

  qt = qtime_open_write(qtfile_name);
  if (!qt) {
    fprintf(stderr, "mov file open failed.\n");
    exit(1);
  }
  vqtrk = qtime_create_track(qt);
  if (!vqtrk) {
    fprintf(stderr, "qtime track create failed.\n");
    exit(1);
  }

  qtime_track_set_video(vqtrk, width, height, fps, compressor);
  vbuf = (uint8_t*) malloc(width * height * 3);

  abuf = NULL;
  aqtrk = NULL;
  if (AVI_audio_bytes(avifile) > 0) {
    uint8_t *comp;
    channels = AVI_audio_channels(avifile);
    bits = AVI_audio_bits(avifile);
    format = AVI_audio_format(avifile);
    rate = AVI_audio_rate(avifile);
    aqtrk = qtime_create_track(qt);
    if (!aqtrk) {
      fprintf(stderr, "qtime track create failed.\n");
      exit(1);
    }
    if (format == 0x55)
      comp = ".mp3";
    else if (format == 0x1)
      comp = "twos";
      //comp = "sowt";
    else
      comp = "";
    qtime_track_set_audio(aqtrk, channels, rate, bits, comp);
    bytespspl = ((bits+7)/8) * channels;
    if (format == 0x55)
      qtime_track_set_audio_ext(aqtrk, 1, -2, 0, 0, 0, bytespspl);
    abuf_size = (int)((double)rate / fps * 1.2) * bytespspl;
    abuf = (uint8_t*) malloc(abuf_size);
  }

  start_sample = 0;
  for (i = 0; i < frames; i++) {
    int size, keyframe;
    size = AVI_read_frame(avifile, vbuf, &keyframe);
    if (size > 0)
      qtime_track_write_video(vqtrk, vbuf, size, keyframe);
    if (aqtrk) {
      end_sample = (int)((double)(i+1) * (double)rate / fps);
      start_sample += audio_write(avifile, aqtrk, end_sample - start_sample);
    }
  }

  if (aqtrk) {
    audio_write_end(avifile, aqtrk);
  }

  if (aqtrk && format == 0x55) {
    qtime_track_set_audio_ext(aqtrk, 1, -2, frame_size, 0, 0, (bits+7)/8);
  }

  AVI_close(avifile);
  qtime_close(qt);

  return 0;
}

