/* ac_oggvorbis.h */

#ifndef _OGGVORBIS_H
#define _OGGVORBIS_H

#include <vorbis/vorbisenc.h>
#include "acodec.h"
#include "ac_oggvorbis.h"


#define OGGVORBIS_FRAME_SIZE 4096

#define OGGVORBIS_ENCODE_MODE_VBR     0
#define OGGVORBIS_ENCODE_MODE_ABR     1
#define OGGVORBIS_ENCODE_MODE_MANAGED 2

typedef struct {
  int max_bitrate;
  int bitrate;
  int min_bitrate;
  int quality;

  int rate;
  int channels;
  int bits;
  int frame_size;
  int vbr;

  uint8_t *header_buf;
  int header_buf_pos;
  int header_buf_size;
  int flushed;
  int analyzed;
  int stream_header;

  ogg_sync_state    oy;
  ogg_stream_state  os;
  ogg_page          og;
  ogg_packet        op;
  vorbis_info       vi;
  vorbis_comment    vc;
  vorbis_dsp_state  vd;
  vorbis_block      vb;

} OGGVORBIS_CONFIG;

extern ACODEC_FUNCS oggvorbis_funcs;

#endif /* _OGGVORBIS_H */

