/* vgrab.h */

#ifndef _VGRAB_H
#define _VGRAB_H

#include <pthread.h>
#include "util.h"
#include "state.h"
#include "vframe_mgr.h"

typedef struct {
  u_time time;
  u_time frame_time;
  uint8_t *bufp;
  uint8_t *data;
} RESTART_FRAME;

typedef struct {
  pthread_t vgrab_th;
  pthread_mutex_t mutex;
  pthread_cond_t interface_wait_cond;
  pthread_cond_t thread_wait_cond;
  STATE state;
  int real_time_flag;
  int rec_start_flag;
  int width;
  int height;
  double fps;
  int csp;
  int pic_data_size;
  unsigned char *pic_data;
  int frame_num;
  int drop_frame_num;

  u_time grab_time;
  u_time last_grab_time;
  u_time time_chunk;
  u_time time_length;
  int time_chunk_num;

  u_time next_time;
  u_time next_next_time;
  double interval;
  double diff_time;
  double base_time;
  int interval_count;
  int loop_count;

  int restart_overlap_frame_num;
  int restart_frame_num;
  RESTART_FRAME *restart_frame;

#if 0
  int yv12_interlace_width;
  int yv12_interlace_height;
  int yv12_interlace_y_stride;
  int yv12_interlace_uv_stride;
  int yv12_interlace_rgb_stride;
  int yv12_interlace_y_offset;
  int yv12_interlace_v_offset;
  int yv12_interlace_u_offset;
#else
  int y_size;
  int uv_size;
  int v_offset;
  int u_offset;
#endif
} VGRAB_CONFIG;

#define VGRAB_OK    0
#define VGRAB_FAIL -1

int vgrab_error_quit (void);
int vgrab_quit (void);
int vgrab_init(int width, int height, double fps, int csp);
int vgrab_state_toggle_pause(void);
int vgrab_state_pause(void);
int vgrab_state_quit(void);
int vgrab_state_stop(void);
int vgrab_state_start(void);
int vgrab_state_error(void);
void vgrab_set_restart(void);
int vgrab_csp_to_vdev_csp(int csp);

#endif /* _VGRAB_H */

