/* video.h */

#ifndef _VIDEO_H
#define _VIDEO_H

#define VIDEO_CODEC_UNKNOWN 0
#define VIDEO_CODEC_RGB     1
#define VIDEO_CODEC_YV12    2
#define VIDEO_CODEC_DIVX    3
#define VIDEO_CODEC_XVID    3

#define DECODE_BUF 1
#define UPDATE_BUF 0

typedef struct {
  int width;
  int height;
  int pix_depth;
  int csp;
  unsigned int prev_intensity;
  unsigned int intensity;
  int keyframe;
  int data_size;
  unsigned char *data;
} VFRAME;

const char *video_get_in_filename(void);
int video_get_prev_key_pos(int position);
int video_get_next_key_pos(int position);
int video_get_in_frames(void);
int video_get_in_pos(void);
double video_get_out_fps(void);
int video_get_total_out_frames(void);
void video_quit(void);
int video_init(void);
int video_get_frames_num(void);
int video_frame_process(int frame_count);
int video_set_in_file(int index);
void video_unset_in_file(int index);
void video_quit(void);
int video_init(void);

#endif /* _DECENC_H */

