/* udta.h */

#ifndef UDTA_H
#define UDTA_H

#include "atom.h"

#define QTIME_TYPE_UDTA    QTIME_TYPE('u','d','t','a')

#define INTER_TEXT_MASK QTIME_TYPE(0xff,0,0,0)
#define INTER_TEXT_TYPE QTIME_TYPE(169,0,0,0)

#define QTIME_TYPE_CPY     QTIME_TYPE(169, 'c', 'p', 'y')
#define QTIME_TYPE_DAY     QTIME_TYPE(169, 'd', 'a', 'y')
#define QTIME_TYPE_DIR     QTIME_TYPE(169, 'd', 'i', 'r')
//#define QTIME_TYPE_ED1     QTIME_TYPE(169, 'e', 'd', '1')
//#define QTIME_TYPE_ED9     QTIME_TYPE(169, 'e', 'd', '9')
#define QTIME_TYPE_FMT     QTIME_TYPE(169, 'f', 'm', 't')
#define QTIME_TYPE_INF     QTIME_TYPE(169, 'i', 'n', 'f')
#define QTIME_TYPE_PRD     QTIME_TYPE(169, 'p', 'r', 'd')
#define QTIME_TYPE_PRF     QTIME_TYPE(169, 'p', 'r', 'f')
#define QTIME_TYPE_REQ     QTIME_TYPE(169, 'r', 'e', 'q')
#define QTIME_TYPE_SRC     QTIME_TYPE(169, 's', 'r', 'c')
#define QTIME_TYPE_WRT     QTIME_TYPE(169, 'w', 'r', 't')
#define QTIME_TYPE_NAME    QTIME_TYPE('n', 'a', 'm', 'e')
#define QTIME_TYPE_WLOC    QTIME_TYPE('W', 'L', 'O', 'C')
#define QTIME_TYPE_LOOP    QTIME_TYPE('L', 'O', 'O', 'P')
#define QTIME_TYPE_SELO    QTIME_TYPE('S', 'e', 'l', 'O')
#define QTIME_TYPE_ALLF    QTIME_TYPE('A', 'l', 'l', 'F')
#define QTIME_TYPE_PTV     QTIME_TYPE('p', 't', 'v', ' ')
#define QTIME_TYPE_HNTI    QTIME_TYPE('h', 'n', 't', 'i')
#define QTIME_TYPE_HINF    QTIME_TYPE('h', 'i', 'n', 'f')

typedef struct {
  uint16_t size;
  uint16_t language_code;
  uint8_t  text[];
} text_t;

typedef struct {
  uint32_t size;
  uint32_t type;
  int32_t  number_of_text;
  text_t** text_list;
} udta_text_t;

typedef struct {
  int16_t  display_size;
  int16_t  reserved1;
  int16_t  reserved2;
  uint8_t  slide_show;
  uint8_t  play_on_open;
} ptv_t;

typedef struct {
  uint32_t  size;
  uint32_t  type;

  union {
    int16_t  wloc[2];
    int32_t  loop;
    uint8_t  selo;
    uint8_t  allf;
    uint8_t* name;
    ptv_t*   ptv;
  } data;
} udta_ctrl_t;

typedef struct {
  atom_t   atom;
  int32_t     number_of_udta_text;
  udta_text_t **udta_text;
  int32_t     number_of_udta_ctrl;
  udta_ctrl_t **udta_ctrl;
//  hnti_t   *hnti;
//  hinf_t   *hinf;
} udta_t;


void    udta_init(udta_t *udta);
void    udta_clean(udta_t *udta);
udta_t* udta_new(void);
void    udta_delete(udta_t *udta);

int64_t udta_calc_size(udta_t *udta);
udta_t* udta_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, udta_t *udta);
udta_t* udta_create(udta_t *udta);
int     udta_write_atom(qtime_io_t *qtio, udta_t *udta);
void    udta_dump(const char *parent_types, udta_t *udta);


#endif /* UDTA_H */

