/* trak.h */

#ifndef TRAK_H
#define TRAK_H

#include "qtime_io.h"
#include "atom.h"
//#include "clip.h"
#include "trak.h"
#include "tkhd.h"
#include "udta.h"
#include "mdia.h"
//#include "matt.h"
#include "edts.h"
#include "tref.h"
#include "load.h"
//#include "imap.h"

#define QTIME_TYPE_TRAK    QTIME_TYPE('t','r','a','k')

typedef struct {
  atom_t   atom;

  tkhd_t   tkhd;    // required

  edts_t   edts;
  mdia_t   mdia;
//  clip_t   *clip;
//  matt_t   *matt;
  tref_t   *tref;
  load_t   *load;
//  imap_t   *imap;
  udta_t   *udta;
} trak_t;


void    trak_init(trak_t *trak);
void    trak_clean(trak_t *trak);
trak_t* trak_new(void);
void    trak_delete(trak_t *trak);

int64_t trak_calc_size(trak_t *trak);
trak_t* trak_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, trak_t *trak);
trak_t* trak_create(trak_t *trak);
int     trak_write_atom(qtime_io_t *qtio, trak_t *trak);

void    trak_dump(const char *parent_types, trak_t *trak);
int     trak_get_id(trak_t *trak);
int     trak_set_id(trak_t *trak, int id);

uint32_t trak_get_media_time_scale(trak_t *trak);
uint32_t trak_get_media_duration(trak_t *trak);
int      trak_set_movie_duration(trak_t *trak, uint32_t movie_duration);


#endif /* TRAK_H */

