/* gmhd.h */

#ifndef GMHD_H
#define GMHD_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_GMHD    QTIME_TYPE('g','m','h','d')

typedef struct {
  atom_t   atom;
} gmhd_t;


void    gmhd_init(gmhd_t *gmhd);
void    gmhd_clean(gmhd_t *gmhd);
gmhd_t* gmhd_new(void);
void    gmhd_delete(gmhd_t *gmhd);

gmhd_t* gmhd_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, gmhd_t *gmhd);
gmhd_t* gmhd_create(gmhd_t *gmhd);
int     gmhd_write_atom(qtime_io_t *qtio, gmhd_t *gmhd);
int64_t gmhd_calc_size(gmhd_t *gmhd);
void    gmhd_dump(const char *parent_types, gmhd_t *gmhd);


#endif /* GMHD_H */

