/* ffmt.h */

#ifndef _FFMT_H
#define _FFMT_H

#include <limits.h>
#include <avilib.h>
#include "util.h"

#include <qtime.h>


#define MAX_FILE_NAME_LENGTH 1024
#define FILE_SIZE_MAX (INT_MAX-(1024*1024*300))
//#define FILE_SIZE_MAX (1024*1024*200)

typedef struct {
  pthread_t ffmt_th;
  pthread_mutex_t mutex;
  pthread_mutex_t wait_cb_mutex;
  pthread_cond_t thread_wait_cond;
  pthread_cond_t interface_wait_cond;
  pthread_cond_t config_wait_cond;
  int wait_cb_called;
  int state;
#define FFMT_FORMAT_UNKNOWN 0
#define FFMT_FORMAT_AVI     1
#define FFMT_FORMAT_RAW     2
#define FFMT_FORMAT_MOV     3
  int format;
  char *name;
  int file_num;
  int file_opend;
  avi_t *avifile;
  qtime_t *qt;
  qtime_track_t *vqtrk;
  qtime_track_t *aqtrk;
  int raw_fd;
  int real_time_flag;

  unsigned long vcodec;
  const char *vfourcc_str;
  int    width;
  int    height;
  double fps;
  int    in_csp;

  unsigned long afourcc;
  int acodec;
  int rate;
  int channels;
  int bitspspl;

  int audio_buf_size;
  int audio_buf_pos;
  uint8_t *audio_buf;

  u_time record_time;
  long long total_sample;
  int drop_frames;
  int video_frame_count;
  int audio_frame_count;
  long long video_data_size;
  long long audio_data_size;
  long long total_data_size;
  long long video_idx_size;
  long long audio_idx_size;
  long long total_idx_size;

} FFMT_CONFIG;

#define FFMT_OK    0
#define FFMT_FAIL -1

int ffmt_state_error(void);
int ffmt_state_start(void);
int ffmt_state_pause(void);
int ffmt_state_toggle_pause(void);
int ffmt_state_stop(void);
int ffmt_state_quit(void);
int ffmt_state_config(const char *name, int format, int width, int height, double fps, unsigned long vfourcc, int acodec, int rate, int channels, int bitspspl);

int    ffmt_get_video_frame_count(void);
u_time ffmt_get_record_time(void);
double ffmt_get_bitrate(void);
long long ffmt_get_total_data_size(void);

void ffmt_dst_wait_cb(void);

int ffmt_init (char *name, int format, int width, int height, double fps,
    unsigned long vfourcc, int acodec, int rate, int channels, int bitspspl);
int ffmt_quit (void);
int ffmt_error_quit (void);
int ffmt_set_file_name(const char *name);
void ffmt_print_param(void);

#endif /* _FFMT_H */

