#ifndef MP3_FRAME_H_INCLUDED
#define MP3_FRAME_H_INCLUDED

#ifndef FALSE
#define         FALSE                   0
#endif
#ifndef TRUE
#define         TRUE                    1
#endif

typedef struct MP3_FRAME_t {
  unsigned long head;
  int version;
#define MP3_VER_1  1
#define MP3_VER_2  2
#define MP3_VER_25 25
  int lsf;
  int layer;
#define MP3_LAY_1  1
#define MP3_LAY_2  2
#define MP3_LAY_3  3
  int protection;
  int bitrate;
  int frequency;
  int padding;
  int private_bit;
  int mode;
#define MP3_MODE_STEREO 0
#define MP3_MODE_JOINT  1
#define MP3_MODE_DUAL   2
#define MP3_MODE_MONO   3
  int mode_ext;
  int copyright;
  int original;
  int emphasis;

  int frame_length;
  int frame_samples;
  int stereo;
} MP3_FRAME;

int mp3_frame_header (MP3_FRAME *frame, unsigned char *stream, int stream_size, int *start);

#if 0
void print_mp3_frame_header (MP3_FRAME *fr);
#endif

#endif /* MP3_FRAME_H_INCLUDED */

