/* mp3_frame.c */

#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>

#include "mp3_frame.h"


static const int tabsel_123 [2] [3] [16] = {
   { {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,},
     {0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,},
     {0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,} },

   { {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256,},
     {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,},
     {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,} }
};

static const long freqs[9] = { 44100, 48000, 32000,
                               22050, 24000, 16000,
                               11025, 12000,  8000 };

static const int smpls[2][4] = {
     /* Layer   I    II   III */
     {0, 384, 1152, 1152}, /* MPEG-1     */
     {0, 384, 1152, 576}   /* MPEG-2(.5) */
};

#if 0
#define XING_HEADER_CHECK_SIZE 40

const static char VBRTag[]  = {"Xing"};
const static char VBRTag2[] = {"Info"};

int VbrTagCheck(unsigned char *buf)
{
	int h_bitrate, h_id, h_mode, h_sr_index;
	int samprate, headersize;

	/* get selected MPEG header data */
	h_id       = ((buf[1] >> 3) & 1) ? 0 : 1;
	h_sr_index = (buf[2] >> 2) & 3;
	h_mode     = (buf[3] >> 6) & 3;
        h_bitrate  = ((buf[2]>>4)&0xf);
	h_bitrate = tabsel_123[h_id][2][h_bitrate];

        /* check for FFE syncword */
        if ((buf[1]>>4)==0xE) 
            samprate = freqs[6 + h_sr_index];
        else
            samprate = freqs[h_id*3 + h_sr_index];

	/*  determine offset of header */
	if( !h_id )
	{
                /* mpeg1 */
		if( h_mode != 3 )	buf+=(32+4);
		else			buf+=(17+4);
	}
	else
	{
                /* mpeg2 */
		if( h_mode != 3 ) buf+=(17+4);
		else              buf+=(9+4);
	}

	if( buf[0] != VBRTag[0] && buf[0] != VBRTag2[0]) return 0;    /* fail */
	if( buf[1] != VBRTag[1] && buf[1] != VBRTag2[1]) return 0;    /* header not found*/
	if( buf[2] != VBRTag[2] && buf[2] != VBRTag2[2]) return 0;
	if( buf[3] != VBRTag[3] && buf[3] != VBRTag2[3]) return 0;

	headersize = 
	  ((2-h_id)*72000*h_bitrate) / samprate;

	return headersize;       /* success */
}
#endif

#if 0
int VbrTagCheck(unsigned char *buf)
{
	int h_bitrate, h_id, h_mode, h_sr_index;
	int samprate, headersize;

	/* get selected MPEG header data */
	h_id       = (buf[1] >> 3) & 1);
	h_sr_index = (buf[2] >> 2) & 3;
	h_mode     = (buf[3] >> 6) & 3;
        h_bitrate  = ((buf[2]>>4)&0xf);
	h_bitrate = bitrate_table[h_id][h_bitrate];

        /* check for FFE syncword */
        if ((buf[1]>>4)==0xE) 
            samprate = samplerate_table[2][h_sr_index];
        else
            samprate = samplerate_table[h_id][h_sr_index];

	/*  determine offset of header */
	if( h_id )
	{
                /* mpeg1 */
		if( h_mode != 3 )	buf+=(32+4);
		else			buf+=(17+4);
	}
	else
	{
                /* mpeg2 */
		if( h_mode != 3 ) buf+=(17+4);
		else              buf+=(9+4);
	}

	if( buf[0] != VBRTag[0] && buf[0] != VBRTag2[0]) return 0;    /* fail */
	if( buf[1] != VBRTag[1] && buf[1] != VBRTag2[1]) return 0;    /* header not found*/
	if( buf[2] != VBRTag[2] && buf[2] != VBRTag2[2]) return 0;
	if( buf[3] != VBRTag[3] && buf[3] != VBRTag2[3]) return 0;

	headersize = 
	  ((h_id+1)*72000*h_bitrate) / samprate;

	return headersize;       /* success */
}
#endif

/*
 * the code a header and write the information
 * into the frame structure
 */

static int decode_header(MP3_FRAME *fr, unsigned long newhead)
{
  int bitrate_index = 0;
  int freq_index = 0;

    if( newhead & (1<<20) ) {
      if (newhead & (1<<19)) {
	fr->lsf = 0x0;
        fr->version = MP3_VER_1;
      } else {
	fr->lsf = 0x1;
        fr->version = MP3_VER_2;
      }
    }
    else {
      fr->lsf = 0x1;
      fr->version = MP3_VER_25;
    }

    fr->layer = 4-((newhead>>17)&3);
    if( ((newhead>>10)&0x3) == 0x3) {
      fprintf(stderr,"Stream error\n");
      exit(1);
    }

    fr->protection = ((newhead>>16)&0x1)^0x1;

//    if(fr->version == MP3_VER_25) /* allow Bitrate change for 2.5 ... */
//      bitrate_index = ((newhead>>12)&0xf);
    bitrate_index = ((newhead>>12)&0xf);

    if(fr->version == MP3_VER_25)
      freq_index = 6 + ((newhead>>10)&0x3);
    else
      freq_index = ((newhead>>10)&0x3) + (fr->lsf*3);

    fr->padding   = ((newhead>>9)&0x1);
    fr->private_bit = ((newhead>>8)&0x1);
    fr->mode      = ((newhead>>6)&0x3);
    fr->mode_ext  = ((newhead>>4)&0x3);
    fr->copyright = ((newhead>>3)&0x1);
    fr->original  = ((newhead>>2)&0x1);
    fr->emphasis  = newhead & 0x3;

    fr->stereo    = (fr->mode == MP3_MODE_MONO) ? 1 : 2;
    fr->frequency = freqs[freq_index];
    fr->frame_samples = smpls[fr->lsf][fr->layer];

    switch(fr->layer)
    {
      case 1:
        fr->bitrate = tabsel_123[fr->lsf][0][bitrate_index];
	fr->frame_length =
	  ((fr->bitrate * 12000 / fr->frequency + fr->padding)<<2);
        break;
      case 2:
        fr->bitrate = tabsel_123[fr->lsf][1][bitrate_index];
	fr->frame_length =
	  (fr->bitrate * 144000 / fr->frequency + fr->padding);
        break;
      case 3:
	if (bitrate_index==0) {
          fr->bitrate = 0;
	  fr->frame_length=0;
	}
	else{
          fr->bitrate = tabsel_123[fr->lsf][2][bitrate_index];
          fr->frame_length =
	    (fr->bitrate * 144000 / ((fr->frequency)<<(fr->lsf)) + fr->padding);
	}
        break; 
      default:
        fprintf(stderr,"Sorry, layer %d not supported\n",fr->layer); 
        return (0);
    }
    /*    print_header(fr); */

    return 1;
}

static int
sync_header (uint8_t *stream, int stream_size, uint32_t *head_ret)
{
  uint32_t head;
  int hpos = 0;
  int layer = 0;

  head = 0;
  for (hpos = 0; hpos < stream_size-3; hpos++) {
    if (stream[hpos] == 0xff) {
      if ((stream[hpos+1]&0xe0) == 0xe0) {
	((uint8_t*)&head)[0] = stream[hpos+3];
	((uint8_t*)&head)[1] = stream[hpos+2];
	((uint8_t*)&head)[2] = stream[hpos+1];
	((uint8_t*)&head)[3] = stream[hpos];
        layer = 4-((head>>17)&3);
        if (4 == layer || ((head>>12)&0xf) == 0xf || ((head>>10)&0x3) == 0x3 )
          head = 0;
	else
	  break;
      }
    }
  }

  *head_ret = head;
  return hpos;
}

int
mp3_frame_header (MP3_FRAME *frame, uint8_t *stream, int stream_size, int *start)
{
  int bytes;
  uint32_t head;

  bytes = sync_header (stream, stream_size, &head);
  *start = bytes;
  frame->head = head;

  if (head == 0)
    return 0;

#if 0
  {
    int vbr_header_size;
    if (stream_size-bytes < XING_HEADER_CHECK_SIZE)
      return 0;
    vbr_header_size = VbrTagCheck(frame, stream+bytes);
    if (vbr_header_size) {
      frame->frame_length = vbr_header_size;
      frame->frame_samples = 0;
      printf("vbr_header_size %d\n", frame->frame_length);
    }
  }
#endif

  decode_header (frame, head);

  return frame->frame_length;
}

#if 0
void print_mp3_frame_header (MP3_FRAME *fr)
{
  static const char *modes[4] = { "Stereo", "Joint-Stereo", "Dual-Channel", "Single-Channel" };
  static const char *layers[4] = { "Unknown" , "I", "II", "III" };
  static const char *on = "ON";
  static const char *off = "OFF";
  static const char *yes = "YES";
  static const char *no = "NO";

  printf ("head:              0x%X\n", (int)fr->head);
  printf ("version:           MPEG %s\n",
      (fr->version == MP3_VER_25) ? "2.5" : (fr->lsf ? "2.0" : "1.0"));
  printf ("layer:             Layer %s\n", layers[fr->layer]);
  printf ("protection:        %s\n", fr->protection ? on : off);
  printf ("bitrate:           %d kbps\n", fr->bitrate);
  printf ("frequency:         %d\n", fr->frequency);
  printf ("padding:           %s\n", fr->padding ? on : off);
  printf ("private_bit:       %s\n", fr->private_bit ? on : off);
  printf ("mode:              %s\n", modes[fr->mode]);
  printf ("mode_ext:          %d\n", fr->mode_ext);
  printf ("copyright:         %s\n", fr->copyright ? yes : no);
  printf ("original:          %s\n", fr->original ? yes : no);
  printf ("emphasis:          %d\n", fr->emphasis);
  printf ("frame_length:      %d bytes\n", fr->frame_length);
  printf ("frame_samples: %d bytes\n", fr->frame_samples);
  printf ("\n");
}

#endif

