/* aread.h */

#ifndef _AREAD_H
#define _AREAD_H

#include <inttypes.h>
#include <pthread.h>
#include "util.h"
#include "state.h"
#include "aframe_mgr.h"

#define AREAD_FLAG_START   (1L<<0)
#define AREAD_FLAG_RECORD  (1L<<1)
#define AREAD_FLAG_DROP    (1L<<2)
#define AREAD_FLAG_STOP    (1L<<3)
#define AREAD_FLAG_QUIT    (1L<<4)
#define AREAD_FLAG_ERROR   (1L<<5)
#define AREAD_FLAG_OVERRUN (1L<<6)

typedef struct {
  uint32_t flag;
  u_time time;
} VINFO;

typedef struct {
  u_time time;
  uint8_t *data;
} READ_FRAME;

typedef struct {
  pthread_t aread_th;
  pthread_mutex_t mutex;
  pthread_cond_t config_wait_cond;
  pthread_cond_t interface_wait_cond;
  pthread_cond_t thread_wait_cond;
  STATE state;

  double rate;
  int channels;
  int format;
  int bitspspl;
  int bytespspl;
  int fragsize;
  int fragstotal;

  int grab_sync;
  int record_flag;

  uint8_t *read_bufp;
  int read_frame_num;
  int read_frame_buf_size;
  int read_frame_spl_size;
  READ_FRAME *read_frame;
  int read_frame_pos;
  int read_frame_top;
  int read_frame_bottom;
  int read_frame_bottom_offset;
  int read_frame_cur;
  int read_frame_cur_offset;

  int time_chunk_num;
  double time_chunk;
  double time_length;
  u_time last_read_time;
  u_time read_time;

  u_time record_time;
  uint32_t video_frames;
  long long read_samples;
  double last_gap;
  double spl_gap;

  VINFO *vinfo;
#define VINFO_NUM 128
  int vinfo_num;
  int vinfo_top;
  int vinfo_bottom;

  int vfrm_spl;

  AFRAME *aframe;
  int afrm_spl_size;

  int interp_count;

} AREAD_CONFIG;

#define AREAD_OK    0
#define AREAD_FAIL -1

#define AREAD_BUF_UNDERRUN -2
#define AREAD_BUF_OVERRUN  -3

#define INTERP_INTERVAL 256

int aread_error_quit (void);
int aread_quit (void);
int aread_init(int rate, int channels, int format);
int aread_state_config(int width, int height, double fps, int csp);
int aread_state_toggle_pause(void);
int aread_state_pause(void);
int aread_state_quit(void);
int aread_state_stop(void);
int aread_state_start(void);
int aread_state_error(void);
int aread_set_vinfo(uint32_t flag, u_time time);

#endif /* _AREAD_H */

