/* aenc.h */

#ifndef _AENC_H
#define _AENC_H

typedef struct {
  pthread_t aenc_th;
  pthread_mutex_t mutex;
  pthread_cond_t interface_wait_cond;
  pthread_cond_t thread_wait_cond;
  int wait_cb_called;
  int state;
  uint32_t codec;
  int rate;
  int channels;
  int bitspspl;
} AENC_CONFIG;

#define AENC_OK    0
#define AENC_FAIL -1

int aenc_state_error(void);
int aenc_state_start(void);
int aenc_state_pause(void);
int aenc_state_toggle_pause(void);
int aenc_state_stop(void);
int aenc_state_quit(void);
int aenc_state_config(uint32_t codec, int rate, int channels, int bitspspl);

void aenc_enc_wait_cb(void);

int aenc_init(uint32_t codec, int rate, int channels, int bitspspl);
int aenc_quit (void);
int aenc_error_quit (void);

#endif /* _AENC_H */

