/* acodec.h */

#ifndef _ACODEC_H
#define _ACODEC_H

#include <inttypes.h>

#define ACODEC_UNKNOWN   0
#define ACODEC_PCM       1
#define ACODEC_PCM_LE    2
#define ACODEC_PCM_BE    3
#define ACODEC_MP3       4
#define ACODEC_OGGVORBIS 5

#define ACODEC_OK              0
#define ACODEC_FAIL           -1
#define ACODEC_NEED_MORE_DATA -2

#define ACODEC_CAP_NONE     0
#define ACODEC_CAP_ANALYSIS 1


typedef struct _ACODEC_tag ACODEC;

typedef struct {
  const char* (*get_codec_name) (void);
  uint32_t    (*get_cap) (uint32_t codec);
  uint32_t    (*fourcc_to_codec) (const char *fourcc);
  uint32_t    (*code_to_codec) (int code);
  const char* (*codec_to_fourcc) (uint32_t codec);
  int         (*codec_to_code) (uint32_t codec);

  int  (*encode_init) (ACODEC *acodec);
  int  (*encode_quit) (void);
  int  (*encode) (void *pcm_buf[], int *num_samples, uint8_t *stream_buf, int stream_buf_size);
  int  (*encode_flush) (int *num_samples, uint8_t *stream_buf, int stream_buf_size);
  int  (*encode_rate_cap) (int rate);
  int  (*encode_channels_cap) (int channels);
  int  (*encode_bits_cap) (int bits);
  int  (*encode_get_frame_size) (void);
  int  (*encode_get_bitrate) (void);
  int  (*encode_get_out_rate) (void);
  void (*encode_print_param) (void);

  int  (*decode_init) (ACODEC *acodec);
  int  (*decode_quit) (void);
  int  (*decode) (void *pcm_buf[], uint8_t *stream, int stream_size);
  int  (*decode_get_rate) (void);
  int  (*decode_get_channels) (void);
  int  (*decode_get_bits) (void);
  int  (*decode_get_bitrate) (void);
  int  (*decode_analyze_stream)(ACODEC *acodec,uint8_t *stream,int stream_size);
  void (*decode_print_param) (void);
} ACODEC_FUNCS;

struct _ACODEC_tag {
  uint32_t codec;
  int rate;
  int channels;
  int bits;
  ACODEC_FUNCS *funcs;
};



const char* acodec_get_codec_name (uint32_t codec);
uint32_t    acodec_get_cap (uint32_t codec, uint32_t cap_flag);
uint32_t    acodec_fourcc_to_codec (const char *fourcc);
uint32_t    acodec_code_to_codec (int code);
const char* acodec_codec_to_fourcc (uint32_t codec);
int         acodec_codec_to_code (uint32_t codec);


int acodec_encode_set_codec(uint32_t codec);
extern int (*acodec_encode)(void *pic_data[], int *num_samples,
    uint8_t *stream_buf, int stream_buf_size);
int acodec_encode_flush(int *num_samples, uint8_t *stream_buf, int stream_buf_size);
int acodec_encode_rate_cap(int rate);
int acodec_encode_channels_cap(int channels);
int acodec_encode_bits_cap(int bitspspl);
int acodec_encode_get_frame_size(void);
int acodec_encode_get_bitrate(void);
int acodec_encode_get_out_rate(void);

int acodec_encode_init(uint32_t codec, int rate, int channels, int bits);
int acodec_encode_reset(void);
int acodec_encode_quit(void);
void acodec_encode_print_param(void);


int acodec_decode_set_codec(uint32_t codec);
int acodec_decode_init(uint32_t codec, int rate, int channels, int bits);
int acodec_decode_quit(void);
int acodec_decode_reset(void);
extern int (*acodec_decode)(void *pic_data[], uint8_t *stream, int stream_size);
int acodec_decode_analyze_stream(uint8_t *stream,int stream_size, int *rate, int *channels, int *bits);
int acodec_decode_get_rate(void);
int acodec_decode_get_channels(void);
int acodec_decode_get_bits(void);
int acodec_decode_get_bitrate(void);
void acodec_decode_print_param(void);


#endif /* _ACODEC_H */

