/* term_util.c */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/select.h>
#include <termios.h>

static struct termios old_state;
static int term_init_flag;

void
term_init (void)
{
  struct termios new_state;

  if (tcgetattr(fileno(stdin), &old_state) != 0) {
    perror ("term_init() tcgetattr error: ");
    term_init_flag = 0;
    return;
  }
  new_state = old_state;
  new_state.c_iflag &= ~(IGNBRK|BRKINT|PARMRK|ISTRIP|INLCR|IGNCR|ICRNL|IXON);
  new_state.c_oflag |= OPOST;
  new_state.c_lflag &= ~(ECHO|ECHONL|ICANON|IEXTEN);
  new_state.c_cflag &= ~(CSIZE|PARENB);
  new_state.c_cflag |= CS8;
  new_state.c_cc[VMIN] = 1;
  new_state.c_cc[VTIME] = 0;

  tcsetattr (fileno(stdin), TCSANOW, &new_state);
  term_init_flag = 1;
}

void
term_quit (void)
{
  if (term_init_flag)
    tcsetattr (fileno(stdin), TCSANOW, &old_state);
}

int
read_key (void)
{
  struct timeval tv;
  int n;
  unsigned char ch;
  fd_set rfds;

  FD_ZERO(&rfds);
  FD_SET(fileno(stdin), &rfds);
  tv.tv_sec = 0;
  tv.tv_usec = 0;
  n = select(1, &rfds, NULL, NULL, &tv);
  if (n > 0) {
    if (read(fileno(stdin), &ch, 1) == 1)
      return ch;
  }
  return -1;
}

