/* ndecenc.c */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <libgen.h>

#include "avilib.h"
#include "xvid.h"

#include "video.h"
#include "audio.h"
#include "ifile.h"
#include "ofile.h"
#include "ndecenc.h"
#include "parseopt.h"
#include "term_util.h"
#include "util.h"

const char *prog_name = NULL;
//const char *defaults_file_name = NULL;
#define DEFAULTS_FILE_NAME "~/.ntvrec/ndecenc.defaults"

int
show_help(void)
{
//  unsigned char *ver = (unsigned char*) &version;
  char *ver = VERSION;
  printf("\n"
         "%s version %s Copyright (c) 2003 nejik\n"
         "\n"
	 "usage: %s [OUTPUT FILE OPTIONS] <[INPUT FILE OPTIONS] <input_file>> [[INPUT FILE OPTIONS] <input_file> ...]\n"
	 , prog_name, ver, prog_name);
  parseopt_print_cmd_opt();
  exit(0);
}

OptionDef main_opt[] = {
    { "h", NULL, 0, {(void*)show_help}, {0}, {0}, 0, "show help", NULL },
//    { "defsfile", NULL, HAS_ARG|OPT_STR|OPT_BEFORE, {(void*)&defaults_file_name}, {(int)"~/.ntvrec/ndecenc.defaults"}, {0}, 0, "defaults file name" },
};

int main_opt_num = sizeof(main_opt) / sizeof(OptionDef);

#ifdef HAVE_LIBXVIDCORE
extern OptionDef xvid_param[];
extern int xvid_param_num;
#endif /* HAVE_LIBXVIDCORE */
#ifdef HAVE_LIBMP3LAME
extern OptionDef mp3_param[];
extern int mp3_param_num;
#endif /* HAVE_LIBMP3LAME */
#ifdef HAVE_LIBAVCODEC
extern OptionDef vlavc_param[];
extern int vlavc_param_num;
#endif /* HAVE_LIBAVCODEC */


OptionDefs options[] = {
  {main_opt,    &main_opt_num,      NULL},
  {in_file_param, &in_file_param_num, "INPUT FILE OPTIONS"},
  {out_file_param, &out_file_param_num, "OUTPUT FILE OPTIONS"},
  {audio_param, &audio_param_num,  "AUDIO OPTIONS"},
#ifdef HAVE_LIBXVIDCORE
  {xvid_param,  &xvid_param_num,   "XVID OPTIONS"},
#endif /* HAVE_LIBXVIDCORE */
#ifdef HAVE_LIBAVCODEC
  {vlavc_param,  &vlavc_param_num,   "LIBAVCODEC OPTIONS"},
#endif /* HAVE_LIBAVCODEC */
#ifdef HAVE_LIBMP3LAME
  {mp3_param,  &mp3_param_num,   "LIBAVCODEC OPTIONS"},
#endif /* HAVE_LIBMP3LAME */
  {NULL, NULL, NULL}
};

void
prog_quit(void)
{
  term_quit();
  parseopt_quit();
}

int
main (int argc, char *argv[])
{
  int out_frame_count;
  int in_file_num = 0;
  int in_file_count = 0;
  int out_frame_num = 0;
  int ch;
  int frm_num;
  int frm_count;
  int frame_rate;
  double out_fps;
  int v_bytes;
  int v_data_size;
  int a_bytes;
  int a_data_size;
  int av_bytes;
  double frame_time;
  u_time start_time;
  u_time end_time;

  prog_name = basename(argv[0]);

  parseopt_set_default_func (set_in_filename);
  parseopt_set_option_defs (options);

  //parseopt_print_rc_opt();
  //exit(0);

  parseopt_defaults(DEFAULTS_FILE_NAME);
  parseopt_cmd(argc, argv);

  init_iofile();
  video_init();
  audio_init();

  in_file_num = get_in_file_num();

  start_time = get_cur_u_time();

  printf ("\n");
  printf ("Press 'q' to quit\n");
  printf ("\n");

  term_init();
  atexit(prog_quit);

  out_fps = video_get_out_fps();
  frame_rate = out_fps;
  frame_time = 1.0 / out_fps;

  out_frame_num = video_get_total_out_frames();

  out_frame_count = 0;
  v_bytes = a_bytes = 0;
  v_data_size = a_data_size = 0;
  av_bytes = 0;

  for (in_file_count = 0; in_file_count < in_file_num; in_file_count++) {
    video_set_in_file(in_file_count);
    frm_num = video_get_frames_num();
    audio_set_in_file(in_file_count);
    for (frm_count = 0; frm_count < frm_num; frm_count++, out_frame_count++) {
      ch = read_key();
      if (ch == 'q' || ch == 'Q') {
	in_file_num = 0;
        break;
      }

      v_data_size = video_frame_process(frm_count);
      if (v_data_size < 0) {
	fprintf(stderr, "main: video_frame_process return %d\n", v_data_size);
	break;
      }
      v_bytes += v_data_size;

      a_data_size = audio_frame_process(frm_count);
//      if (a_data_size < 0) {
//	fprintf(stderr, "main: audio_frame_process return %d\n", a_data_size);
//	break;
//      }
      a_bytes += a_data_size;

      av_bytes = v_bytes + a_bytes;

      //if (!(out_frame_count % frame_rate)) {
        printf("frames=% 8d/%d:% 3d%% size=%8ukB bitrate=%6.1fkbits/s\r",
//        printf("frames=% 8d/%d:% 3d%% size=%8ukB bitrate=%6.1fkbits/s\n",
	    out_frame_count, out_frame_num, out_frame_count*100/out_frame_num,
	    (av_bytes) / 1024,
	    (av_bytes) * 8.0 / (out_frame_count * frame_time) / 1000.0);
        fflush (stdout);
      //}
      if (out_frame_num <= out_frame_count)
        break;
    }
    audio_unset_in_file(in_file_count);
    video_unset_in_file(in_file_count);
    if (out_frame_num <= out_frame_count)
      break;
  }

  audio_flush();

  audio_quit();
  video_quit();
  quit_iofile();

  printf("frames=% 8d/%d:% 3d%% size=%8ukB bitrate=%6.1fkbits/s\n",
	 out_frame_count, out_frame_num, out_frame_count*100/out_frame_num,
	 (av_bytes) / 1024,
	 (av_bytes) * 8.0 / (out_frame_count * frame_time) / 1000.0);
  end_time = get_cur_u_time();
  end_time = end_time - start_time;

  {
    int h,m,s;

    end_time /= 1000000;
    s = end_time % 60;
    end_time = (end_time - s) / 60;
    m = end_time % 60;
    end_time = (end_time - m) / 60;
    h = end_time;
    printf("time %3dh%2dm%2ds\n", h, m ,s);
  }

  printf("\nquit\n");

  exit(0);
}

