/* deinterlace.h */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Referenced:
 * xaw-deinterlaceerlace
 * http://
 *
 * Copyright:
 * Conrad Kreyling <conrad@conrad.nerdland.org>
 * Patrick Barrett <yebyen@nerdland.org
 * This is licenced under the GNU GPL until someone tells me I'm stealing code
 * and can't do that ;) www.gnu.org for any version of the license.
 *
 */

#ifndef _DEINTERLACE_H
#define _DEINTERLACE_H

#include <inttypes.h>

#define DEINTERLACE_LINEAR_BLEND 0
#define DEINTERLACE_BILINEAR     1
#define DEINTERLACE_LINEDOUBLING 2
#define DEINTERLACE_DENOISE      3

typedef void (*DeinterlaceFunc) (uint8_t *, uint8_t*);

DeinterlaceFunc deinterlace_find_type (const char *type, int *type_id);
int deinterlace_init (int width, int height, const char *type, int type_id, int in_csp);
int deinterlace_set_y_only(int flag);
int deinterlace_set_uv_only(int flag);
const char *deinterlace_get_type(void);

extern DeinterlaceFunc deinterlace;

#endif /* _DEINTERLACE_H */

