/* mgr.h */

#ifndef _MGR_H
#define _MGR_H

#include <pthread.h>

typedef struct {
  pthread_mutex_t mutex;
  int state;
  int width;
  int height;
  double fps;
  int grab_csp;
  int out_csp;
  int vcodec;
  unsigned long vfourcc;
  int max_buffers;

  const char *vdev_name;
  int vdev_source_channel;
  int vdev_tuner;
  int vdev_norm;
  int vdev_audio;
  int vdev_brightness;
  int vdev_hue;
  int vdev_colour;
  int vdev_contrast;
  int vdev_whiteness;
  int vdev_freq;

  const char *adev_name;
  const char *adev_mixer_name;
  const char *adev_source;
  int audio_codec;
  int audio_rate;
  int audio_out_rate;
  int audio_channels;
  int audio_bits;

  char *output_fname;
  int file_format;
} MGR_CONFIG;

#define MGR_OK    0
#define MGR_FAIL -1

#define VGRAB_THREAD 1
#define VENC_THREAD  2
#define AREAD_THREAD 3
#define AENC_THREAD  4
#define FFMT_THREAD  5

int mgr_init(void);
int mgr_quit(void);
int mgr_error_quit(void);
int mgr_state_start(void);
int mgr_state_pause(void);
int mgr_state_toggle_pause(void);
int mgr_state_stop(void);
int mgr_state_quit(void);
int mgr_error_occured(int sender);
void mgr_set_restart(void);

int mgr_set_output_file_name(const char *arg);
void mgr_print_param(void);

#endif /* _MGR_H */

